package com.ishop.merchant.controller;

import com.iplatform.base.Constants;
import com.iplatform.base.pojo.KeywordsParam;
import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbProductRule;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商户端 -> 商品规格 --> 前端：merchant,product,attr
 * @date 2023-07-31
 */
@RestController
@RequestMapping("/merchant/product/rule")
public class MerProductRuleController extends BaseController {

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue info(Long id){
        if(id == null || id <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        EbProductRule productRule = this.getProductRuleService().get(new EbProductRule(id));
        return ResponseValue.success(productRule);
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue update(@RequestBody EbProductRule productRule){
        if(productRule == null || productRule.getId() == null || productRule.getId() <= 0){
            return ResponseValue.error("请提交编辑规格信息");
        }
        this.getProductRuleService().save(productRule);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/delete}", method = RequestMethod.POST)
    public ResponseValue remove(Long id){
        if(id == null || id <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        this.getProductRuleService().delete(new EbProductRule(id));
        return ResponseValue.success();
    }

    /**
     * 新增商品规格
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ResponseValue save(@RequestBody EbProductRule productRule){
        if(productRule == null || StringUtils.isEmpty(productRule.getRuleName())){
            return ResponseValue.error("请提交规格信息");
        }

        int merchantId = this.getCurrentUser().getMer_id().intValue();
        if(this.getProductRuleService().queryExistRuleName(merchantId, productRule.getRuleName())){
            return ResponseValue.error("规格名称已存在");
        }

        productRule.setMerId(merchantId);
        productRule.setId(NumberGenerator.getLongSequenceNumber());
        this.getProductRuleService().insert(productRule);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(KeywordsParam param){
        String keywords = null;
        if(param != null){
            keywords = param.getKeywords();
        }
        int merchantId = this.getCurrentUser().getMer_id().intValue();
        GenericPager<EbProductRule> pager = this.getProductRuleService().queryPageRuleList(merchantId, keywords);
        return ResponseValue.success(pager);
    }
}
