package com.ishop.merchant.controller;

import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbCoupon;
import com.walker.db.page.GenericPager;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商户优惠券管理。
 * @author 时克英
 * @date 2023-06-22
 */
@RestController
@RequestMapping("/merchant/coupon")
public class MerchantCouponController extends BaseController {

    @RequestMapping(value = "/product/usable/list", method = RequestMethod.GET)
    public ResponseValue getProductUsableList(){
        int merId = this.getCurrentUser().getMer_id().intValue();
        return ResponseValue.success(this.getCouponService().queryProductUsableList(merId));
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        int merId = this.getCurrentUser().getMer_id().intValue();
        EbCoupon param = new EbCoupon();
        param.setMerId(merId);
        GenericPager<EbCoupon> pager = this.getCouponService().selectSplit(param);
        return ResponseValue.success(pager);
    }
}
