package com.ishop.merchant.controller;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.Constants;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.vo.MerchantConfigInfoVo;
import com.ishop.model.vo.MerchantVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商户端商户信息控制器
 * @author 时克英
 * @date 2023-06-06
 */
@RestController
@RequestMapping("/merchant")
public class MerchantInfoController extends BaseController {

//    @ApiOperation(value = "商户端商户基础信息")
    @RequestMapping(value = "/base/info", method = RequestMethod.GET)
    public ResponseValue getBaseInfo(){
        long merchantId = this.getCurrentUser().getMer_id();
        if(merchantId <= 0){
            return ResponseValue.error("您不是商户，无法使用该功能");
        }

        EbMerchant merchant = this.getMerchantService().get(new EbMerchant((int)merchantId));
        if(merchant == null){
            return ResponseValue.error("商户不存在");
        }
        MerchantVo merchantVo = new MerchantVo(merchant);
//        merchant.setParameterString("merCategory", this.getMerchantCategoryName(merchant.getCategoryId()));
//        merchant.setParameterString("merType", this.getMerchantTypeName(merchant.getTypeId()));
        merchantVo.setMerCategory(this.getMerchantCategoryName(merchant.getCategoryId()));
        merchantVo.setMerType(this.getMerchantTypeName(merchant.getTypeId()));
        return ResponseValue.success(merchantVo);
    }

    @RequestMapping(value = "/config/info", method = RequestMethod.GET)
    public ResponseValue getConfigInfo(){
        long merchantId = this.getCurrentUser().getMer_id();
        if(merchantId <= 0){
            throw new IllegalStateException("非商户调用");
        }
        EbMerchant merchant = this.getMerchantService().get(new EbMerchant((int)merchantId));
        EbMerchantInfo merchantInfo = this.getMerchantService().get(new EbMerchantInfo((int)merchantId));
        MerchantConfigInfoVo vo = VoUtils.transferTo(merchant, merchantInfo, this.getCdnUrl());
        return ResponseValue.success(vo);
    }

    @RequestMapping(value = "/settlement/info", method = RequestMethod.GET)
    public ResponseValue getSettlementInfo(){
        long merchantId = this.getCurrentUser().getMer_id();
        if(merchantId <= 0){
            throw new IllegalStateException("非商户调用");
        }
        EbMerchantInfo merchantInfo = this.getMerchantService().get(new EbMerchantInfo((int)merchantId));
        return ResponseValue.success(merchantInfo);
    }

    @RequestMapping(value = "/config/info/edit", method = RequestMethod.POST)
    public ResponseValue configInfoEdit(@RequestBody MerchantConfigInfoVo merchantConfigInfoVo){
        long merchantId = this.getCurrentUser().getMer_id();
        if(merchantId <= 0){
            throw new IllegalStateException("非商户调用");
        }
        this.checkConfigInfo(merchantConfigInfoVo);

        EbMerchant currentMerchant = this.getMerchantService().get(new EbMerchant((int)merchantId));
        currentMerchant.setBackImage(this.clearCdnPrefix(merchantConfigInfoVo.getBackImage()));
        currentMerchant.setAvatar(this.clearCdnPrefix(merchantConfigInfoVo.getAvatar()));
        currentMerchant.setRectangleLogo(this.clearCdnPrefix(merchantConfigInfoVo.getRectangleLogo()));
        currentMerchant.setCoverImage(this.clearCdnPrefix(merchantConfigInfoVo.getCoverImage()));
        currentMerchant.setStreetBackImage(this.clearCdnPrefix(merchantConfigInfoVo.getStreetBackImage()));
        currentMerchant.setKeywords(merchantConfigInfoVo.getKeywords());
        currentMerchant.setIntro(merchantConfigInfoVo.getIntro());
        currentMerchant.setAddressDetail(merchantConfigInfoVo.getAddressDetail());
        currentMerchant.setIsTakeTheir(merchantConfigInfoVo.getIsTakeTheir());
        currentMerchant.setLatitude(merchantConfigInfoVo.getLatitude());
        currentMerchant.setLongitude(merchantConfigInfoVo.getLongitude());
        if(StringUtils.isNotEmpty(merchantConfigInfoVo.getPcBanner())){
            currentMerchant.setPcBanner(this.clearCdnPrefix(merchantConfigInfoVo.getPcBanner()));
        }
        if(StringUtils.isNotEmpty(merchantConfigInfoVo.getPcBackImage())){
            currentMerchant.setPcBackImage(this.clearCdnPrefix(merchantConfigInfoVo.getPcBackImage()));
        }

        EbMerchantInfo merchantInfo = this.getMerchantService().get(new EbMerchantInfo((int)merchantId));
        merchantInfo.setServiceLink(merchantConfigInfoVo.getServiceLink());
        merchantInfo.setServicePhone(merchantConfigInfoVo.getServicePhone());
        merchantInfo.setServiceType(merchantConfigInfoVo.getServiceType());
        merchantInfo.setAlertStock(merchantConfigInfoVo.getAlertStock());

        this.getMerchantService().execUpdateConfigInfo(currentMerchant, merchantInfo);
        return ResponseValue.success();
    }

    /**
     * 更新商户结算信息，银行卡、微信、支付宝等。
     * @param merchantInfo
     * @return
     * @date 2023-06-07
     */
    @RequestMapping(value = "/settlement/info/edit", method = RequestMethod.POST)
    public ResponseValue settlementInfoEdit(@RequestBody EbMerchantInfo merchantInfo){
        long merchantId = this.getCurrentUser().getMer_id();
        if(merchantId <= 0){
            throw new IllegalStateException("非商户调用");
        }
        this.settlementInfoCheck(merchantInfo);

        EbMerchantInfo existMerchantInfo = this.getMerchantService().get(new EbMerchantInfo((int)merchantId));
        if(existMerchantInfo == null){
            return ResponseValue.error("商户信息不存在");
        }

        merchantInfo.setId(existMerchantInfo.getId());

        if(!merchantInfo.getSettlementType().equals(Constants.MERCHANT_SETTLEMENT_TYPE_BANK)){
            if(StringUtils.isNotEmpty(merchantInfo.getWechatQrcodeUrl())){
                merchantInfo.setWechatQrcodeUrl(this.clearCdnPrefix(merchantInfo.getWechatQrcodeUrl()));
            }
            if(StringUtils.isNotEmpty(merchantInfo.getAlipayQrcodeUrl())){
                merchantInfo.setAlipayQrcodeUrl(this.clearCdnPrefix(merchantInfo.getAlipayQrcodeUrl()));
            }
        }
        this.getMerchantService().save(merchantInfo);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/switch/update", method = RequestMethod.POST)
    public ResponseValue updateSwitch(){
        long merchantId = this.getCurrentUser().getMer_id();
        if(merchantId <= 0){
            throw new IllegalStateException("非商户调用");
        }
        EbMerchant currentMerchant = this.getMerchantService().get(new EbMerchant((int)merchantId));
        EbMerchant update = new EbMerchant();
        update.setId((int)merchantId);
        if(currentMerchant.getIsSwitch() == 1){
            update.setIsSwitch(0);
            logger.warn("关闭商户，同时下线所有商品，代码需要完善！");
//            productService.downByMerId(merchant.getId());
        } else {
            update.setIsSwitch(1);
            logger.warn("开启商户，同时要检查商户配置和客服信息，代码需要完善！");
//            openMerchantValidator(merchant);
        }
        this.getMerchantService().save(update);
        return ResponseValue.success();
    }

    private void checkConfigInfo(MerchantConfigInfoVo request){
        if (request.getServiceType().equals(Constants.MERCHANT_SERVICE_TYPE_H5)) {
            if (StringUtils.isEmpty(request.getServiceLink())) {
                throw new PlatformRuntimeException("客服H5链接不能为空");
            }
            if (!StringUtils.isHttpLink(request.getServiceLink())) {
                throw new PlatformRuntimeException("客服H5链接格式不正确");
            }
        }
        if (request.getServiceType().equals(Constants.MERCHANT_SERVICE_TYPE_PHONE)) {
            if (StringUtils.isEmpty(request.getServicePhone())) {
                throw new PlatformRuntimeException("客服电话不能为空");
            }
        }
    }

    /**
     * 结算信息校验
     */
    private void settlementInfoCheck(EbMerchantInfo request) {
        if (request.getSettlementType().equals(Constants.MERCHANT_SETTLEMENT_TYPE_BANK)) {
            if (StringUtils.isEmpty(request.getBankUserName())) {
                throw new PlatformRuntimeException("持卡人姓名不能为空");
            }
            if (StringUtils.isEmpty(request.getBankName())) {
                throw new PlatformRuntimeException("银行名称不能为空");
            }
            if (StringUtils.isEmpty(request.getBankCard())) {
                throw new PlatformRuntimeException("银行卡号不能为空");
            }
            if (StringUtils.isEmpty(request.getBankAddress())) {
                throw new PlatformRuntimeException("开户地址不能为空");
            }
        }
        if (request.getSettlementType().equals(Constants.MERCHANT_SETTLEMENT_TYPE_WECHAT)) {
            if (StringUtils.isEmpty(request.getWechatCode())) {
                throw new PlatformRuntimeException("微信号不能为空");
            }
            if (StringUtils.isEmpty(request.getWechatQrcodeUrl())) {
                throw new PlatformRuntimeException("微信收款二维码不能为空");
            }
            if (StringUtils.isEmpty(request.getRealName())) {
                throw new PlatformRuntimeException("真实姓名不能为空");
            }
        }
        if (request.getSettlementType().equals(Constants.MERCHANT_SETTLEMENT_TYPE_ALIPAY)) {
            if (StringUtils.isEmpty(request.getAlipayCode())) {
                throw new PlatformRuntimeException("支付宝账号不能为空");
            }
            if (StringUtils.isEmpty(request.getAlipayQrcodeUrl())) {
                throw new PlatformRuntimeException("支付宝收款二维码不能为空");
            }
        }
    }
}
