package com.ishop.merchant.controller;

import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.pojo.MenuParam;
import com.iplatform.base.util.MenuUtils;
import com.iplatform.base.util.menu.SystemMenu;
import com.ishop.merchant.BaseController;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Iterator;
import java.util.List;

/**
 * 商户（独立机构）菜单管理。
 * @author 时克英
 * @date 2023-06-06
 */
@RestController
@RequestMapping("/platform/merchant/menu")
public class MerchantMenuController extends BaseController {

    private MenuCacheProvider menuCacheProvider;

    @Autowired
    public MerchantMenuController(MenuCacheProvider menuCacheProvider){
        this.menuCacheProvider = menuCacheProvider;
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(MenuParam menuParam){
        List<SystemMenu> menuList = this.menuCacheProvider.getMenuList(null, MenuUtils.MENU_SCOPE_ORG);
        if(menuList != null && menuParam != null){
            boolean hasName = StringUtils.isNotEmpty(menuParam.getName());
            boolean hasMenuType = StringUtils.isNotEmpty(menuParam.getMenuType());
            SystemMenu menu = null;
            for(Iterator<SystemMenu> it = menuList.iterator(); it.hasNext();){
                menu = it.next();
//                if(menu.getStatus().equals(MenuUtils.MENU_STATUS_DISABLED)){
//                    it.remove();
//                }
                if(hasMenuType && !menu.getMenu_type().equals(menuParam.getMenuType())){
                    it.remove();
                    continue;
                }
                if(hasName && !menu.getMenu_name().contains(menuParam.getName())){
                    it.remove();
                    continue;
                }
            }
        }
        return ResponseValue.success(menuList);
    }

}
