package com.ishop.merchant.controller;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.UserSearchParam;
import com.ishop.model.po.EbUser;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/merchant/user")
public class MerchantUserController extends BaseController {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(UserSearchParam param){
        long merId = this.getCurrentUser().getMer_id();
        GenericPager<EbUser> pager = null;
        if(param == null){
            pager = this.getUserRegisterService().queryPageMerchantUserList((int)merId, null,null,null);
        } else {
            pager = this.getUserRegisterService().queryPageMerchantUserList((int)merId, param.getNikename(), param.getPhone(), param.getRegisterType());
        }
        if(!StringUtils.isEmptyList(pager.getDatas())){
            for(EbUser e : pager.getDatas()){
                if(StringUtils.isNotEmpty(e.getAvatar())){
                    e.setAvatar(this.getCdnUrl() + e.getAvatar());
                }
            }
        }
        return ResponseValue.success(pager);
    }

    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    public ResponseValue detail(Long id){
        if(id == null || id.longValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        EbUser user = this.getUserRegCache().get(id);
        if(user == null){
            return ResponseValue.error("无效用户");
        }
        return ResponseValue.success(user);
    }
}
