package com.ishop.merchant.controller;

import com.iplatform.base.pojo.KeywordsParam;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.Constants;
import com.ishop.model.po.EbShippingTemplates;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

//@Api(tags = "商户端 -- 运费模板")
@RestController
@RequestMapping("/merchant/shipping/templates")
public class ShippingTemplateController extends BaseController {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(KeywordsParam keywordsParam){
        String keywords = null;
        if(keywordsParam != null && StringUtils.isNotEmpty(keywordsParam.getKeywords())){
            keywords = keywordsParam.getKeywords();
        }
        int merchantId = this.getCurrentUser().getMer_id().intValue();
        GenericPager<EbShippingTemplates> pager = this.getShippingTemplateService().queryPageShippingTemplateList(merchantId, keywords);

        // 把 虚拟商品 无需发货物流方式加入，2023-09-09
        List<EbShippingTemplates> data = pager.getDatas();
        if(StringUtils.isEmptyList(data)){
            data = new ArrayList<>(2);
        }
        data.add(this.createOtherShippingType(merchantId));
        pager = ListPageContext.createGenericPager(data, pager.getPageIndex(), pager.getPageSize(), (int)pager.getTotalRows());
        return ResponseValue.success(pager);
    }

    private EbShippingTemplates createOtherShippingType(int merchantId){
        EbShippingTemplates templates = new EbShippingTemplates();
        templates.setId(Constants.SHIPPING_TEMPLATE_ID_NO_SEND);
        templates.setMerId(merchantId);
        templates.setType(Constants.CHARGE_MODE_TYPE_UNKNOWN);
        templates.setName(Constants.SHIPPING_TEMPLATE_NAME_NO_SEND);
        templates.setAppoint(Constants.APPOINT_TYPE_ALL);
        templates.setSort(0);
        templates.setCreateTime(DateUtils.getDateTimeNumber());
        return templates;
    }
}
