package com.ishop.merchant.platform;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.vo.ArticleCategoryVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/platform/article/category")
public class ArticleCategoryController extends BaseController {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        GenericPager<EbArticleCategory> pager = this.getArticleService().queryPageCategoryList();
        List<EbArticleCategory> list = pager.getDatas();
        if(StringUtils.isEmptyList(list)){
            return ResponseValue.success(pager);
        }
        String cdnUrl = this.getCdnUrl();
        List<ArticleCategoryVo> voList = new ArrayList<>(list.size());
        for(EbArticleCategory e : list){
            voList.add(VoUtils.acquireArticleCategoryVo(e, cdnUrl));
        }
//        return ResponseValue.success(ListPageContext.createGenericPager(voList, pager.getPageIndex(), pager.getPageSize(), (int)pager.getTotalRows()));
        return ResponseValue.success(voList);
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseValue addCategory(@RequestBody EbArticleCategory request){
        if(request == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        if(StringUtils.isEmpty(request.getName())){
            return ResponseValue.error("请输入文章分类名称");
        }
        request.setIsDel(0);
        request.setStatus(1);
        if(StringUtils.isNotEmpty(request.getIcon())){
            request.setIcon(this.clearCdnPrefix(request.getIcon()));
        }
        request.setId(NumberGenerator.getLongSequenceNumber());
        request.setCreateTime(DateUtils.getDateTimeNumber());
        request.setUpdateTime(request.getCreateTime());
        this.getArticleService().insert(request);
        this.getArticleCategoryCache().save(VoUtils.acquireArticleCategoryVo(request, this.getCdnUrl()));
        return ResponseValue.success();
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseValue removeCategory(Long id){
        if(id == null || id <= 0){
            return ResponseValue.error("请输入文章分类");
        }
        if(this.getArticleService().queryCategoryUsed(id)){
            return ResponseValue.error("分类正在使用，无法删除");
        }
        this.getArticleService().delete(new EbArticleCategory(id));
        this.getArticleCategoryCache().remove(id);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/switch", method = RequestMethod.POST)
    public ResponseValue categorySwitch(Long id){
        if(id == null || id <= 0){
            return ResponseValue.error("请输入文章分类");
        }
        EbArticleCategory category = new EbArticleCategory();
        ArticleCategoryVo exist = this.getArticleCategoryCache().get(id);
        if(exist.getStatus()){
            category.setStatus(0);
            exist.setStatus(false);
        } else {
            category.setStatus(1);
            exist.setStatus(true);
        }
        category.setId(id);

        this.getArticleService().update(category);
        this.getArticleCategoryCache().update(exist);
        return ResponseValue.success();
    }
}
