package com.ishop.merchant.platform;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.ArticleParam;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticle;
import com.ishop.model.request.ArticleRequest;
import com.ishop.model.vo.ArticleVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/platform/article")
public class ArticleController extends BaseController {

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseValue delete(Long id){
        if(id == null || id <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        this.getArticleService().execDeleteArticle(id);
        return ResponseValue.success();
    }
    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue info(Long id){
        return this.acquireArticleDetailVo(id);
    }

    @RequestMapping(value = "/switch", method = RequestMethod.POST)
    public ResponseValue articleSwitch(Long id){
        if(id == null || id <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        EbArticle article = this.getArticleService().get(new EbArticle(id));
        article.setStatus(article.getStatus().intValue() == 1? 0:1);
        this.getArticleService().update(article);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue update(@RequestBody ArticleRequest request){
        if(request == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        if(request.getId() == null || request.getId() <= 0){
            return ResponseValue.error("文章id错误");
        }
        if(StringUtils.isEmpty(request.getTitle()) || StringUtils.isEmpty(request.getContent())){
            return ResponseValue.error("内容不能为空");
        }
        EbArticle exist = this.getArticleService().get(new EbArticle(request.getId()));
        if(exist == null){
            return ResponseValue.error("数据不存在");
        }

        if(StringUtils.isNotEmpty(request.getCover())){
            request.setCover(this.clearCdnPrefix(request.getCover()));
        }
        request.setContent(this.clearCdnPrefix(request.getContent()));
        EbArticle article = VoUtils.acquireEbArticle(request, this.getCdnUrl());
        article.setCreateTime(exist.getCreateTime());
        this.getArticleService().update(article);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ResponseValue save(@RequestBody ArticleRequest request){
        if(request == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        if(StringUtils.isEmpty(request.getTitle()) || StringUtils.isEmpty(request.getContent())){
            return ResponseValue.error("内容不能为空");
        }
        if(StringUtils.isNotEmpty(request.getCover())){
            request.setCover(this.clearCdnPrefix(request.getCover()));
        }
        request.setContent(this.clearCdnPrefix(request.getContent()));
        request.setId(NumberGenerator.getLongSequenceNumber());
        EbArticle article = VoUtils.acquireEbArticle(request, this.getCdnUrl());
        this.getArticleService().insert(article);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(ArticleParam param){
        Long cid = null;
        String title = null;
        String author = null;
        if(param != null){
            cid = param.getCid();
            title = param.getTitle();
            author = param.getAuthor();
        }
        GenericPager<EbArticle> pager = this.getArticleService().queryPageAdminList(cid, title, author);
        List<EbArticle> list = pager.getDatas();
        if(StringUtils.isEmptyList(list)){
            return ResponseValue.success(pager);
        }

        String cdnUrl = this.getCdnUrl();
        List<ArticleVo> data = new ArrayList<>(list.size());
        for(EbArticle e : list){
            data.add(VoUtils.acquireArticleVo(e, cdnUrl, false));
        }
        return ResponseValue.success(ListPageContext.createGenericPager(data, pager.getPageIndex(), pager.getPageSize(), (int)pager.getTotalRows()));
    }
}
