package com.ishop.merchant.platform;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.model.po.EbMerchantCategory;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 平台端商户分类管理。
 * @date 2023-06-01
 */
@RestController
@RequestMapping("/platform/merchant/category")
public class MerchantCategoryController extends BaseController {

    private MerchantCategoryServiceImpl merchantCategoryService;

    @Autowired
    public MerchantCategoryController(MerchantCategoryServiceImpl merchantCategoryService){
        this.merchantCategoryService = merchantCategoryService;
    }

//    @ApiOperation(value="商户分类分页列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        GenericPager<EbMerchantCategory> pager = this.merchantCategoryService.selectSplit(new EbMerchantCategory());
        return ResponseValue.success(pager);
    }

    @RequestMapping(value = "/all", method = RequestMethod.GET)
    public ResponseValue listAll(){
        List<EbMerchantCategory> list = this.merchantCategoryService.selectAll(new EbMerchantCategory());
        return ResponseValue.success(list);
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseValue add(@RequestBody EbMerchantCategory category){
        if(category == null || StringUtils.isEmpty(category.getName())){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        category.setId(this.merchantCategoryService.queryNextId());
        this.merchantCategoryService.insert(category);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue update(@RequestBody EbMerchantCategory category){
        if(category == null || category.getId() == null || category.getId().intValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        this.merchantCategoryService.save(category);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseValue delete(Integer id){
        if(id == null || id.intValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        this.merchantCategoryService.delete(new EbMerchantCategory(id));
        return ResponseValue.success();
    }
}
