package com.ishop.merchant.platform;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.model.po.EbMerchantType;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 商铺类型管理
 * @author 时克英
 * @date 2023-06-02
 */
@RestController
@RequestMapping("/platform/merchant/type")
public class MerchantTypeController extends BaseController {

    private MerchantTypeServiceImpl merchantTypeService;

    @Autowired
    public MerchantTypeController(MerchantTypeServiceImpl merchantTypeService){
        this.merchantTypeService = merchantTypeService;
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        GenericPager<EbMerchantType> pager = this.merchantTypeService.selectSplit(new EbMerchantType());
        return ResponseValue.success(pager);
    }
    @RequestMapping(value = "/all", method = RequestMethod.GET)
    public ResponseValue listAll(){
        List<EbMerchantType> pager = this.merchantTypeService.selectAll(new EbMerchantType());
        return ResponseValue.success(pager);
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseValue add(@RequestBody EbMerchantType type){
        if(type == null || StringUtils.isEmpty(type.getName())){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        type.setCreateTime(DateUtils.getDateTimeNumber());
        type.setUpdateTime(type.getCreateTime());
        type.setIsDel(0);
        type.setId(this.merchantTypeService.queryNextId());
        this.merchantTypeService.insert(type);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue update(@RequestBody EbMerchantType type){
        if(type == null || type.getId() == null || type.getId().intValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        type.setUpdateTime(DateUtils.getDateTimeNumber());
        this.merchantTypeService.save(type);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseValue delete(Integer id){
        if(id == null || id.intValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        this.merchantTypeService.delete(new EbMerchantType(id));
        return ResponseValue.success();
    }
}
