package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.OrderParam;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.OrderCountVo;
import com.ishop.model.vo.OrderDetailFrontVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.time.TimeRangeUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 平台订单管理
 * @date 2023-07-20
 */
@RestController
@RequestMapping("/platform/order")
public class PlatformOrderController extends BaseController {

    /**
     * 获取订单发货单列表
     * @return
     */
    @RequestMapping(value = "/invoice/list", method = RequestMethod.GET)
    public ResponseValue getInvoiceList(String orderNo){
        if(StringUtils.isEmpty(orderNo)){
            return ResponseValue.error("订单编号不存在");
        }
//        EbOrderInvoice param = new EbOrderInvoice();
//        param.setOrderNo(orderNo);
//        List<EbOrderInvoice> orderInvoiceList = this.getOrderInvoiceService().select(param);
//        if(StringUtils.isEmptyList(orderInvoiceList)){
//            return ResponseValue.success(new ArrayList<>(1));
//        }
//
//        List<Long> invoiceIdList = orderInvoiceList.stream().map(EbOrderInvoice::getId).collect(Collectors.toList());
//        List<EbOrderInvoiceDetail> orderInvoiceDetailList = this.getOrderInvoiceService().queryOrderInvoiceDetailList(invoiceIdList);
//        if(StringUtils.isEmptyList(orderInvoiceDetailList)){
//            return ResponseValue.success(new ArrayList<>(1));
//        }
////        Map<Long, EbOrderInvoice> cacheInvoice = new HashMap<>(4);
////        for(EbOrderInvoice e : orderInvoiceList){
////            cacheInvoice.put(e.getId(), e);
////        }
//
//        List<OrderInvoiceVo> list = new ArrayList<>(4);
//        OrderInvoiceVo vo = null;
//        for(EbOrderInvoice e : orderInvoiceList){
//            vo = VoUtils.acquireOrderInvoiceVo(e);
//            for(EbOrderInvoiceDetail ed: orderInvoiceDetailList){
//                if(ed.getInvoiceId().longValue() == vo.getId().longValue()){
//                    vo.addDetailVo(VoUtils.acquireOrderInvoiceDetailVo(ed));
//                }
//            }
//            list.add(vo);
//        }
        List<OrderInvoiceVo> list = this.acquireOrderInvoiceList(orderNo);
        return ResponseValue.success(list);
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue info(String orderNo){
        if(StringUtils.isEmpty(orderNo)){
            return ResponseValue.error("订单编号不存在");
        }
        EbOrder order = this.getOrderService().queryOrder(orderNo);
        if(order == null){
            return ResponseValue.error("订单不存在");
        }
//        EbMerchantOrder merchantOrder = this.getOrderService().queryMerchantOrderOne(orderNo);
//        List<EbOrderDetail> detailList = this.getOrderService().queryOrderDetailList(orderNo);
//
//        EbUser user = this.getUserRegCache().get(order.getUid());
//        EbMerchant merchant = this.getMerchantCache().get(merchantOrder.getMerId());
//        PlatformOrderDetailVo vo = VoUtils.acquirePlatformOrderDetailVo(order, merchantOrder);
////        vo.setSplitOrderNo(mer);
////        vo.setExpressCode(or);
//        vo.setNikeName(user.getNickname());
//        vo.setRealName(user.getRealName());
//        vo.setMerName(merchant.getName());
//        vo.setIsLogoff(user.getIsLogoff().intValue() == 1);
//        if(merchantOrder.getClerkId().longValue() > 0){
//            vo.setClerkName(this.getUser(merchantOrder.getClerkId()).getNick_name());
//        }
//
//        List<OrderDetailFrontVo> orderDetailList = new ArrayList<>(detailList.size());
//        for(EbOrderDetail detail : detailList){
//            orderDetailList.add(VoUtils.acquireOrderDetailFrontVo(detail));
//        }
//        vo.setOrderDetailList(orderDetailList);
        PlatformOrderDetailVo vo = this.acquireCommonOrderDetail(order, orderNo);
        return ResponseValue.success(vo);
    }

    /**
     * 平台端获取订单各状态数量
     * @return
     */
    @RequestMapping(value = "/status/num", method = RequestMethod.GET)
    public ResponseValue getOrderStatusNum(String dateLimit){
        OrderCountVo vo = new OrderCountVo();
        return ResponseValue.success(vo);
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(OrderParam param){
        GenericPager<EbOrder> pager = null;
        if(param == null){
            pager = this.getOrderService().queryPagePlatformOrderList(null, null, null, null, null);
        } else {
            TimeRange timeRange = StringUtils.isEmpty(param.getDateLimit())? null : TimeRangeUtils.getDateLimit(param.getDateLimit());
            pager = this.getOrderService().queryPagePlatformOrderList(param.getMerId(), param.getOrderNo(), param.getType(), timeRange, param.getStatus());
        }

        List<EbOrder> data = pager.getDatas();
        if(StringUtils.isEmptyList(data)){
            return ResponseValue.success(pager);
        }
//        List<PlatformOrderVo> list = new ArrayList<>(data.size());
//        PlatformOrderVo vo = null;
//        EbUser user = null;
//        EbMerchant merchant = null;
//        for(EbOrder order : data){
//            vo = VoUtils.acquirePlatformOrderVo(order);
//            user = this.getUserRegCache().get(order.getUid());
//            vo.setIsLogoff(user.getIsLogoff().intValue() == 1);
//            vo.setNickName(user.getNickname());
//            if(order.getMerId().intValue() > 0){
//                merchant = this.getMerchantCache().get(order.getMerId());
//                vo.setMerName(merchant.getName());
//            }
//            list.add(vo);
//        }
        List<PlatformOrderVo> list = this.acquireCommonOrderList(data);
        return ResponseValue.success(ListPageContext.createGenericPager(list, pager.getPageIndex(), (int)pager.getTotalRows()));
    }

}
