package com.ishop.merchant.platform;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbProductBrand;
import com.ishop.model.vo.ProductBrandVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 平台商品品牌管理
 * @author 时克英
 * @date 2023-06-10
 */
@RestController
@RequestMapping("/platform/product/brand")
public class ProductBrandController extends BaseController {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        GenericPager<EbProductBrand> pager = this.getProductBrandService().selectSplit(new EbProductBrand());
        if(pager.getDatas() != null){
            for(EbProductBrand e : pager.getDatas()){
                if(StringUtils.isNotEmpty(e.getIcon())){
                    e.setIcon(this.getCdnUrl() + e.getIcon());
                }
            }
        }
        return ResponseValue.success(pager);
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseValue add(@RequestBody ProductBrandVo productBrandVo){
        if(productBrandVo == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }

        EbProductBrand brand = new EbProductBrand();
        brand.setName(productBrandVo.getName());
        brand.setSort(productBrandVo.getSort());
        brand.setCreateTime(DateUtils.getDateTimeNumber());
        brand.setUpdateTime(brand.getCreateTime());
        brand.setId(this.getProductBrandService().queryNextId());
        if(StringUtils.isNotEmpty(productBrandVo.getIcon())){
            brand.setIcon(this.clearCdnPrefix(productBrandVo.getIcon()));
        }

        List<Object[]> brandCategoryList = null;
        if(StringUtils.isNotEmpty(productBrandVo.getCategoryIds())){
            brandCategoryList = this.acquireBrandCategoryParameters(brand.getId(), productBrandVo.getCategoryIds());
        }

        this.getProductBrandService().execInsertBrand(brand, brandCategoryList);
        this.getProductBrandCache().save(brand);
        return ResponseValue.success();
    }

//    @RequestMapping(value = "/cache/list", method = RequestMethod.GET)
//    public ResponseValue getCacheAllList(){
//        List<EbProductBrand> data = this.getProductBrandCache().getList();
//        return ResponseValue.success(data);
//    }

    private List<Object[]> acquireBrandCategoryParameters(int brandId, String categoryIds){
        String[] categoryIdArray = StringUtils.commaDelimitedListToStringArray(categoryIds);
        List<Object[]> list = new ArrayList<>(4);
        Object[] one = null;
        for(String categoryId : categoryIdArray){
            one = new Object[2];
            one[0] = brandId;
            one[1] = Integer.parseInt(categoryId);
            list.add(one);
        }
        return list;
    }
}
