package com.ishop.merchant.platform;

import com.iplatform.base.Constants;
import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 因为商品分类，前端使用的一个组件，因此平台分类和商户分类，目前写在一个控制器中。
 * @author 时克英
 * @date 2023-06-19
 */
@RestController
@RequestMapping("/platform/product/category")
public class ProductCategoryController extends BaseController {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
//        GenericPager<EbProductCategory> pager = this.getProductCategoryService().selectSplit(new EbProductCategory());
        if(this.isPlatformSuper()){
            EbProductCategory productCategory = new EbProductCategory();
            productCategory.setIsShow(1);
            productCategory.setIsDel(0);
            List<EbProductCategory> data = this.getProductCategoryService().select(productCategory);
            if(!StringUtils.isEmptyList(data)){
                String icon = null;
                for(EbProductCategory category : data){
                    icon = category.getIcon();
                    if(StringUtils.isNotEmpty(icon)){
                        category.setIcon(this.getCdnUrl() + icon);
                    }
                }
            }
            return ResponseValue.success(data);
        } else if(this.isMerchant()){
            long merchantId = this.getCurrentUser().getMer_id();
            if(merchantId <= 0){
                return ResponseValue.error("您不是商户，无法使用该功能");
            }
            EbMerchantProductCategory category = new EbMerchantProductCategory();
            category.setMerId((int)merchantId);
            category.setIsDel(0);

//            GenericPager<EbMerchantProductCategory> pager = this.getMerchantProductCategoryService().selectSplit(category);
            List<EbMerchantProductCategory> data = this.getMerchantProductCategoryService().select(category);
            if(!StringUtils.isEmptyList(data)){
                String icon = null;
                for(EbMerchantProductCategory c : data){
                    icon = c.getIcon();
                    if(StringUtils.isNotEmpty(icon)){
                        c.setIcon(this.getCdnUrl() + icon);
                    }
                }
            }
            return ResponseValue.success(data);
        } else {
            throw new UnsupportedOperationException("当前用户无法访问");
        }
    }

    @RequestMapping(value = "/cache/tree", method = RequestMethod.GET)
    public ResponseValue getProductCategoryTree(){
        if(this.isPlatformSuper()){
            List<ProductCategoryVo> list = this.getProductCategoryCache().getTree(null);
            return ResponseValue.success(list);

        } else if(this.isMerchant()){
            long merchantId = this.getCurrentUser().getMer_id();
            List<ProductCategoryVo> list = this.getMerProductCategoryCache().getTree(String.valueOf(merchantId));
            return ResponseValue.success(list);
        } else {
            throw new UnsupportedOperationException("当前用户无法访问");
        }
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseValue delete(Integer id){
        EbProductCategory category = this.getProductCategoryService().get(new EbProductCategory(id));
        if(category == null){
            return ResponseValue.error("分类不存在");
        }
        if (category.getLevel() < 3) {
            List<EbProductCategory> categoryList = this.getProductCategoryService().queryChildrenList(category.getId(), category.getLevel());
            if (!StringUtils.isEmptyList(categoryList)) {
                return ResponseValue.error("请先删除子级分类");
            }
        }

        // 判断是否有商品使用该分类
        logger.warn("判断是否有商品使用该分类，需要实现代码------------------>");
        if(this.getProductService().queryExistCategoryProductRef(id)){
            return ResponseValue.error("该分类下已存在商品，无法删除");
        }

        // 判断是否品牌关联该分类
        if(this.getProductCategoryService().queryHasBrand(id) > 0){
            return ResponseValue.error("有品牌关联该分类，无法删除");
        }
        category.setIsDel(1);
        this.getProductCategoryService().save(category);
        this.getProductCategoryCache().remove(id);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue update(@RequestBody EbProductCategory category){
        if(category == null || category.getId() == null || category.getPid() == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        logger.warn("需要判断分类名称重复，和如果是三级分类，需要判断是否有商品/品牌 使用该分类");
        if(StringUtils.isNotEmpty(category.getIcon())){
            category.setIcon(this.clearCdnPrefix(category.getIcon()));
        }
        this.getProductCategoryService().save(category);
        this.getProductCategoryCache().update(category);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseValue add(@RequestBody EbProductCategory category){
        if(category == null || category.getPid() == null || StringUtils.isEmpty(category.getName())){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        if(category.getLevel().intValue() != 1){
            if(category.getPid().intValue() == 0){
                throw new PlatformRuntimeException("子级菜单，父级ID不能为0");
            }
        } else {
            category.setPid(0);
        }
        if(StringUtils.isNotEmpty(category.getIcon())){
            category.setIcon(this.clearCdnPrefix(category.getIcon()));
        }

        if(this.isPlatformSuper()){
            if(this.checkName(category.getName(), category.getPid()) != null){
                return ResponseValue.error("商品分类已存在");
            }

            category.setCreateTime(DateUtils.getDateTimeNumber());
            category.setUpdateTime(category.getCreateTime());
            category.setId(this.getProductCategoryService().queryNextId());
            this.getProductCategoryService().insert(category);
            this.getProductCategoryCache().save(category);
            return ResponseValue.success();

        } else if(this.isMerchant()){
            long merchantId = this.getCurrentUser().getMer_id();
            if(this.checkMerCategoryName((int)merchantId, category.getName(), category.getPid()) != null){
                return ResponseValue.error("商户商品分类已存在");
            }
            EbMerchantProductCategory merchantProductCategory = new EbMerchantProductCategory();
            merchantProductCategory.setPid(category.getPid());
            merchantProductCategory.setName(category.getName());
            merchantProductCategory.setMerId((int)merchantId);
            merchantProductCategory.setIcon(category.getIcon());
            merchantProductCategory.setSort(category.getSort());
            merchantProductCategory.setCreateTime(DateUtils.getDateTimeNumber());
            merchantProductCategory.setUpdateTime(merchantProductCategory.getCreateTime());
            merchantProductCategory.setId(this.getMerchantProductCategoryService().queryNextId());
            this.getMerchantProductCategoryService().insert(merchantProductCategory);
            // 添加商户商品分类时，不用追加缓存，缓存会在没有数据时自动（第一次）查询数据库
//            this.getMerProductCategoryCache().putListAppend(String.valueOf(merchantId), merchantProductCategory);
            return ResponseValue.success();

        } else {
            throw new UnsupportedOperationException("当前用户无法访问");
        }
    }

    private EbMerchantProductCategory checkMerCategoryName(int merId, String name, int pid){
        EbMerchantProductCategory category = new EbMerchantProductCategory();
        category.setMerId(merId);
        category.setIsDel(0);
        category.setName(name);
        category.setPid(pid);
        List<EbMerchantProductCategory> list = this.getMerchantProductCategoryService().select(category);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }

    private EbProductCategory checkName(String name, int pid){
        EbProductCategory category = new EbProductCategory();
        category.setName(name);
        category.setPid(pid);
        category.setIsDel(0);
        List<EbProductCategory> list = this.getProductCategoryService().select(category);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }
}
