package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.ProductParam;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.vo.ProductTabsHeaderVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/platform/product")
public class ProductController extends BaseController {

//    @RequestMapping(value = "/info", method = RequestMethod.GET)
//    public ResponseValue info(Long id){
//        if(id == null || id.longValue() <= 0){
//            return ResponseValue.error(Constants.ERROR_ARGUMENT);
//        }
//        EbProduct product = this.getProductService().get(new EbProduct(id));
//        if(product == null){
//            return ResponseValue.error("商品不存在");
//        }
//
//        ProductInfoVo productInfoVo = new ProductInfoVo();
//        VoUtils.setupProductInfoVo(product, productInfoVo);
//
//        // 2: 设置商品型号属性，如：颜色、类别等
//        List<EbProductAttr> productAttrs = this.getProductAttrCache().getList(ProductAttrUtils.combineKey(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId()));
//        if(!StringUtils.isEmptyList(productAttrs)){
//            productInfoVo.setAttr(productAttrs);
//        }
//
//        // 3: 设置商品属性型号值
//        List<EbProductAttrValue> attrValues = this.getProductAttrValueService().queryProductAttrValueList(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId());
//        if(!StringUtils.isEmptyList(attrValues)){
//           productInfoVo.setAttrValue(attrValues);
//        }
//
//        EbProductDescription description = this.getProductDescriptionService().queryProductDescription(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId());
//        if(description != null){
//            productInfoVo.setContent(description.getDescription() == null? StringUtils.EMPTY_STRING: description.getDescription());
//        }
//
//        // 获取已关联的优惠券
////        List<ProductCoupon> productCouponList = productCouponService.getListByProductId(Product.getId());
////        if (CollUtil.isNotEmpty(productCouponList)) {
////            List<Integer> ids = productCouponList.stream().map(ProductCoupon::getCouponId).collect(Collectors.toList());
////            SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
////            if (systemAdmin.getMerId() > 0) {
////                ProductResponse.setCouponIds(ids);
////            } else {
////                ProductResponse.setCouponList(couponService.findSimpleListByIdList(ids));
////            }
////        }
//        return ResponseValue.success(productInfoVo);
//    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(ProductParam productParam){
        GenericPager<EbProduct> pager = this.getProductService().queryPageProductList(productParam);
        if(!StringUtils.isEmptyList(pager.getDatas())){
            EbMerchant merchant = null;
            for(EbProduct product : pager.getDatas()){
                merchant = this.getMerchantCache().get(product.getMerId());
                product.setParameterString("merchantName", merchant.getName());
                product.setParameterInt("isSelf", merchant.getIsSelf());
                if(StringUtils.isNotEmpty(product.getImage())){
                    product.setImage(this.getCdnUrl() + product.getImage());
                }
            }
        }
        return ResponseValue.success(pager);
    }

    @RequestMapping(value = "/tabs/headers", method = RequestMethod.GET)
    public ResponseValue getTabsHeader(){
        List<ProductTabsHeaderVo> data = this.getProductService().queryTabsHeader();
        return ResponseValue.success(data);
    }
}
