package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.ProductGuaranteeServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbProductGuarantee;
import com.ishop.model.vo.ProductGuaranteeVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 商品保障服务管理。
 * @author 时克英
 * @date 2023-06-13
 */
@RestController
@RequestMapping("/platform/product/guarantee")
public class ProductGuaranteeController extends BaseController {

    private ProductGuaranteeServiceImpl productGuaranteeService;

    @Autowired
    public ProductGuaranteeController(ProductGuaranteeServiceImpl productGuaranteeService){
        this.productGuaranteeService = productGuaranteeService;
    }

    /**
     * 商户新增商品，选择服务保障列表。
     * @param type
     * @return
     * @date 2023-06-21
     */
    @RequestMapping(value = "/all", method = RequestMethod.GET)
    public ResponseValue all(Integer type){
        return ResponseValue.success(this.getProductGuaranteeService().queryProductGuaranteeList(type));
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        List<ProductGuaranteeVo> data = new ArrayList<>();
        List<EbProductGuarantee> list = this.productGuaranteeService.queryProductGuaranteeList(null);
        if(!StringUtils.isEmptyList(list)){
            for(EbProductGuarantee e : list){
                data.add(VoUtils.transferTo(e));
            }
        }
        return ResponseValue.success(data);
    }
}
