package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.TagServiceImpl;
import com.ishop.model.po.EbUserTag;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/platform/user/tag")
public class TagController extends BaseController {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        return ResponseValue.success(this.tagService.selectSplit(new EbUserTag()));
    }

    @RequestMapping(value = "/all/list", method = RequestMethod.GET)
    public ResponseValue listAll(){
        return ResponseValue.success(this.tagService.select(new EbUserTag()));
    }

    @Autowired
    public TagController(TagServiceImpl tagService){
        this.tagService = tagService;
    }
    private TagServiceImpl tagService;
}
