package com.ishop.merchant.pub;

import com.iplatform.base.Constants;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.util.ImageUtils;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttr;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.po.EbProductBrand;
import com.ishop.model.po.EbProductDescription;
import com.ishop.model.vo.ProductInfoVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 公共控制器定义，商品两端通用方法。
 * @author 时克英
 * @date 2023-06-15
 */
@RestController
@RequestMapping("/pub/product")
public class ProductInfoController extends BaseController {

    /**
     * 商品品牌缓存集合，平台、商户端都要使用，看到相同数据。
     * @return
     * @date 2023-06-15
     */
    @RequestMapping(value = "/brand/cache/list", method = RequestMethod.GET)
    public ResponseValue getCacheAllList(){
        List<EbProductBrand> data = this.getProductBrandCache().getList();
        return ResponseValue.success(data);
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue info(Long id){
        if(id == null || id.longValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        EbProduct product = this.getProductService().get(new EbProduct(id));
        if(product == null){
            return ResponseValue.error("商品不存在");
        }

        ProductInfoVo productInfoVo = new ProductInfoVo();
        VoUtils.setupProductInfoVo(product, productInfoVo);
        if(StringUtils.isNotEmpty(productInfoVo.getImage())){
            productInfoVo.setImage(this.getCdnUrl() + productInfoVo.getImage());
        }
        if(StringUtils.isNotEmpty(productInfoVo.getSliderImage())){
            productInfoVo.setSliderImage(ImageUtils.combineMultiImageUrl(productInfoVo.getSliderImage(), this.getCdnUrl()));
        }

        // 2: 设置商品型号属性，如：颜色、类别等
        List<EbProductAttr> productAttrs = this.getProductAttrCache().getList(ProductAttrUtils.combineKey(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId()));
        if(!StringUtils.isEmptyList(productAttrs)){
            productInfoVo.setAttr(productAttrs);
        }

        // 3: 设置商品属性型号值
        List<EbProductAttrValue> attrValues = this.getProductAttrValueService().queryProductAttrValueList(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId());
        if(!StringUtils.isEmptyList(attrValues)){
            productInfoVo.setAttrValue(attrValues);
        }

        EbProductDescription description = this.getProductDescriptionService().queryProductDescription(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId());
        if(description != null){
            productInfoVo.setContent(description.getDescription() == null? StringUtils.EMPTY_STRING: description.getDescription());
        }

        // 获取已关联的优惠券
//        List<ProductCoupon> productCouponList = productCouponService.getListByProductId(Product.getId());
//        if (CollUtil.isNotEmpty(productCouponList)) {
//            List<Integer> ids = productCouponList.stream().map(ProductCoupon::getCouponId).collect(Collectors.toList());
//            SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
//            if (systemAdmin.getMerId() > 0) {
//                ProductResponse.setCouponIds(ids);
//            } else {
//                ProductResponse.setCouponList(couponService.findSimpleListByIdList(ids));
//            }
//        }
        return ResponseValue.success(productInfoVo);
    }

}
