package com.ishop.merchant.service;

import com.ishop.model.po.EbArticle;
import com.ishop.model.po.EbArticleCategory;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ArticleServiceImpl extends BaseServiceImpl {

    private final Sorts.Sort articleSort = Sorts.DESC().setField("id");

    public void execDeleteArticle(long id){
        this.execute("delete from eb_article where id=?", new Object[]{id});
    }

    /**
     * 给定文章分类，是否被引用？
     * @param categoryId
     * @return
     * @date 2023-08-06
     */
    public boolean queryCategoryUsed(long categoryId){
        return this.sqlMathQuery("select count(id) total from eb_article where cid=?", new Object[]{categoryId}, Integer.class) > 0;
    }

    public GenericPager<EbArticleCategory> queryPageCategoryList(){
        EbArticleCategory category = new EbArticleCategory();
        category.setIsDel(0);
        return this.selectSplit(category, Sorts.DESC().setField("id"));
    }

    public GenericPager<EbArticle> queryPageAdminList(Long cid, String title, String author){
        EbArticle param = new EbArticle();
        param.setIsDel(0);
        if(cid != null && cid > 0){
            param.setCid(cid);
        }
        if(StringUtils.isNotEmpty(title)){
            param.setTitle(StringUtils.CHAR_PERCENT + UrlUtils.decode(title) + StringUtils.CHAR_PERCENT);
        }
        if(StringUtils.isNotEmpty(author)){
            param.setAuthor(StringUtils.CHAR_PERCENT + UrlUtils.decode(author) + StringUtils.CHAR_PERCENT);
        }
        return this.selectSplit(param, articleSort);
    }

    /**
     * 查询文章列表
     * @param cid 分类ID，可选
     * @return
     * @date 2023-07-18
     */
    public GenericPager<EbArticle> queryPageArticleList(String cid, Boolean hot, Boolean banner){
        Map<String, Object> param = new HashMap<>(2);
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);
        if(StringUtils.isNotEmpty(cid)){
            sql.append(" and cid=:cid");
            param.put("cid", cid);
        }
        if(hot != null){
            sql.append(" and is_hot=:hot");
            param.put("hot", hot? 1:0);
        }
        if(banner != null){
            sql.append(" and is_banner=:banner");
            param.put("banner", banner? 1:0);
        }
        sql.append(" order by sort desc");
        return this.selectSplit(sql.toString(), param, new EbArticle());
    }

    public List<EbArticle> queryArticleList(Boolean hot, Boolean banner){
        Map<String, Object> param = new HashMap<>(2);
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);
        if(hot != null){
            sql.append(" and is_hot=:hot");
            param.put("hot", hot? 1:0);
        }
        if(banner != null){
            sql.append(" and is_banner=:banner");
            param.put("banner", banner? 1:0);
        }
        sql.append(" order by sort desc");
        return this.select(sql.toString(), param, new EbArticle());
    }

    private static final String SQL_PAGE_LIST = "select * from eb_article where is_del=0 and status=1";

    /**
     * 返回首页热点文章集合。
     * @param limit 限制几条
     * @return
     * @date 2023-06-23
     */
    public List<EbArticle> queryIndexHeadLine(int limit){
        return this.select("select id,title from eb_article where is_del=0 and status=1 and is_hot=1 order by sort desc limit ?", new Object[]{limit}, new EbArticle());
    }
}
