package com.ishop.merchant.service;

import com.ishop.model.po.EbCityRegion;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CityServiceImpl extends BaseServiceImpl {

    /**
     * 查询条件匹配的城市区域列表。
     * @param regionType 区域类型
     * @param parentId 上级ID
     * @return
     */
    public List<EbCityRegion> queryCityList(Integer regionType, Integer parentId){
        EbCityRegion region = new EbCityRegion();
        if(regionType != null){
            region.setRegionType(regionType);
        }
        if(parentId != null){
            region.setParentId(parentId);
        }
        return this.select(region);
    }

    /**
     * 获取，城市区域集合，组装缓存树使用。
     * <p>该方法只会被缓存对象调用一次。</p>
     * @return
     * @date 2023-06-25
     */
    public List<EbCityRegion> queryAllCityForCacheTree(){
        return this.select("select region_id, parent_id, region_name, region_type from eb_city_region order by region_type asc", new Object[]{}, new EbCityRegion());
    }
}
