package com.ishop.merchant.service;

import com.ishop.model.po.EbCouponUser;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Service
public class CouponUserServiceImpl extends BaseServiceImpl {

    /**
     * 更新用户优惠券为“已使用”
     * @param couponIdList 优惠券ID集合
     * @date 2023-07-09
     */
    public void execUpdateUseCoupons(List<Long> couponIdList){
        Map<String, Object> param = new HashMap<>(2);
        param.put("ids", couponIdList);
        this.execute("update eb_coupon_user set status=1 where id in (:ids)", param);
    }

    /**
     * 获取订单可用的优惠券集合。该方法需要优化，感觉写的很丑。
     * @param preOrderNo
     * @param merId
     * @param maxPrice
     * @param date
     * @param uid
     * @param pidList
     * @return
     * @date 2023-07-09
     */
    public List<EbCouponUser> queryListByPreOrderNo(String preOrderNo, Integer merId, Double maxPrice, Long date
            , Long uid, List<Long> pidList){
        Map<String, Object> param = new HashMap<>(2);
        StringBuilder sql = new StringBuilder("select * from eb_coupon_user cu where cu.status = 0");
        if(merId != null){
            sql.append(" and cu.mer_id = :merId");
            param.put("merId", merId);
        }
        sql.append(" and (cu.min_price = 0");
        if(maxPrice != null && maxPrice.doubleValue() > 0){
            sql.append(" or cu.min_price <= :maxPrice");
            param.put("maxPrice", maxPrice);
        }
        sql.append(")");
        if(date != null && date.longValue() > 0){
            sql.append(" and cu.start_time < :date");
            sql.append(" and cu.end_time > :date");
            param.put("date", date);
        }
        if(uid != null && uid.longValue() > 0){
            sql.append(" and cu.uid = :uid");
            param.put("uid", uid);
        }
        sql.append(" and (cu.category = 1 or (cu.category = 2");

        String pidPrimaryKeySql = this.getPidPrimaryKeySql(pidList);
        sql.append(" and ").append(pidPrimaryKeySql).append(" order by cu.id desc");
        log.debug("=========== {}", sql);
        return this.select(sql.toString(), param, new EbCouponUser());
    }

    /**
     * 获取商品拼接sql
     *
     * @param pidList 商品id列表
     */
    private String getPidPrimaryKeySql(List<Long> pidList) {
        List<String> sqlList = new ArrayList<>();
        pidList.forEach(pid -> {
            String sql = pid + " in (select pid from eb_coupon_product where cid = cu.coupon_id)";
            sqlList.add(sql);
        });
        return "( " + org.apache.commons.lang3.StringUtils.join(sqlList, " or ") + ")";
    }

    /**
     * 返回用户拥有的优惠券Map对象，key = 优惠券ID，value = EbCouponUser
     * @param userId
     * @return
     * @date 2023-07-09
     */
    public Map<Integer, EbCouponUser> queryCouponIdAndValue(long userId){
        List<EbCouponUser> list = this.select("select * from eb_coupon_user where uid=?", new Object[]{userId}, new EbCouponUser());
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        Map<Integer, EbCouponUser> map = new HashMap<>();
        for(EbCouponUser info: list){
            map.put(info.getCouponId(), info);
        }
        return map;
    }

    /**
     * 获取用户可用优惠券数量
     * @param userId
     * @return
     * @date 2023-06-30
     */
    public int queryUserCouponCount(long userId){
        EbCouponUser param = new EbCouponUser();
        param.setUid(userId);
        param.setStatus(0);
        List<EbCouponUser> list = this.select(param);
        if(StringUtils.isEmptyList(list)){
            return 0;
        }
        long currentTime = DateUtils.getDateTimeNumber();
        EbCouponUser e = null;
        for(Iterator<EbCouponUser> it = list.iterator(); it.hasNext();){
            e = it.next();
            if(e.getStartTime().longValue() > 0 && e.getEndTime().longValue() > 0){
                if(currentTime < e.getStartTime().longValue() || currentTime > e.getEndTime().longValue()){
                    it.remove();
                    continue;
                }
            }
        }
        return StringUtils.isEmptyList(list)? 0: list.size();
    }

    private static final String SQL_COLLECTION_LIST = "select * from eb_coupon_user where uid=? and status=?";
}
