package com.ishop.merchant.service;

import com.ishop.merchant.ExpressConstants;
import com.ishop.model.po.EbExpress;
import com.walker.db.Sorts;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ExpressServiceImpl extends BaseServiceImpl {

    private final Sorts.Sort idSort = Sorts.ASC().setField("id");

    /**
     * 获取可用的快递公司列表
     * @param type
     * @return
     * @date 2023-08-21
     */
    public List<EbExpress> queryAvailableList(String type){
        EbExpress param = new EbExpress();
        param.setIsShow(1);
        if(type != null && type.equals(ExpressConstants.TYPE_ELE)){
            param.setStatus(0);
        } else {
            param.setStatus(1);
        }
        return this.select(param, idSort);
    }

    /**
     * 根据快递代码查询唯一快递公司。
     * @param code
     * @return
     * @date 2023-08-20
     */
    public EbExpress queryOne(String code){
        EbExpress param = new EbExpress();
        param.setCode(code);
        List<EbExpress> list = this.select(param);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }
}
