package com.ishop.merchant.service;

import com.ishop.merchant.Constants;
import com.ishop.model.po.EbMerchantApply;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 商户审核。
 * @date 2023-06-05
 */
@Service
public class MerchantApplyServiceImpl extends BaseServiceImpl {

    /**
     * 根据名称查询等待审批的申请记录
     * @param name
     * @return
     */
    public EbMerchantApply queryApplyByName(String name){
        EbMerchantApply apply = new EbMerchantApply();
        apply.setName(name);
        apply.setAuditStatus(Constants.AUDIT_STATUS_WAIT);
        List<EbMerchantApply> list = this.select(apply);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }

    public EbMerchantApply queryApplyByPhone(String phone){
        EbMerchantApply apply = new EbMerchantApply();
        apply.setPhone(phone);
        apply.setAuditStatus(Constants.AUDIT_STATUS_WAIT);
        List<EbMerchantApply> list = this.select(apply);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }
}
