package com.ishop.merchant.service;

import com.ishop.model.po.EbOrderInvoiceDetail;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 订单发货数据操作
 * @date 2023-07-20
 */
@Service
public class OrderInvoiceServiceImpl extends BaseServiceImpl {

    /**
     * 根据发货id集合，返回明细记录
     * @param choiceIds
     * @return
     */
    public List<EbOrderInvoiceDetail> queryOrderInvoiceDetailList(List<Long> choiceIds){
        Map<String, Object> param = new HashMap<>(2);
        param.put("ids", choiceIds);
        return this.select("select * from eb_order_invoice_detail where invoice_id in (:ids)", param, new EbOrderInvoiceDetail());
    }
}
