package com.ishop.merchant.service;

import com.iplatform.model.po.S_pay_notify;
import com.iplatform.pay.service.PlatformOrderServiceImpl;
import com.ishop.merchant.BalanceRecordConstants;
import com.ishop.merchant.Constants;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.util.PayUtils;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbRechargeOrder;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserBalanceRecord;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.NumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl extends BaseServiceImpl {

    private UserRegisterServiceImpl userRegisterService;
    private PlatformOrderServiceImpl platformOrderService;

    @Autowired
    public PayServiceImpl(UserRegisterServiceImpl userRegisterService, PlatformOrderServiceImpl platformOrderService){
        this.userRegisterService = userRegisterService;
        this.platformOrderService = platformOrderService;
    }

    /**
     * 微信充值，支付通知确认更新数据。
     * @param rechargeOrder
     * @param balanceRecord
     * @param payPrice
     * @param s_pay_notify
     * @param existNotify
     * @date 2023-09-12
     */
    public void execRechargeWechatNotify(EbRechargeOrder rechargeOrder
            , EbUserBalanceRecord balanceRecord, double payPrice, S_pay_notify s_pay_notify, boolean existNotify){
        // 更新充值订单状态
        this.update(rechargeOrder);
        // 写入余额变动流水
        this.insert(balanceRecord);
        // 更新用户账户金额
        userRegisterService.execUpdateMoney(rechargeOrder.getUid(), payPrice, Constants.OPERATION_TYPE_ADD);
        if(existNotify){
            // 更新通知，更新订单状态
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, false);
        } else {
            // 写入通知，更新订单状态
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, true);
        }
    }

    /**
     * 微信支付，接收通知成功，更新订单状态。H5支付方式。
     * @param order
     * @param s_pay_notify
     * @param existNotify
     * @date 2023-08-11
     */
    public void execPayWechatPublic(EbOrder order, S_pay_notify s_pay_notify, boolean existNotify){
        // 订单修改
        order.setPaid(1);
        order.setPayTime(DateUtils.getDateTimeNumber());
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        this.save(order);
        this.doProcessMerchantOrder(order);

        if(existNotify){
            // 更新通知，更新订单状态
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, false);
        } else {
            // 写入通知，更新订单状态
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, true);
        }
    }

    /**
     * 余额支付订单操作。
     * @param order
     * @param payPrice
     * @param userId
     * @param md5Key 系统配置的md5密钥
     * @date 2023-07-12
     */
    public void execPayYue(EbOrder order, double payPrice, long userId, String md5Key, EbUser user){
        // 订单修改
        order.setPaid(1);
        order.setPayTime(DateUtils.getDateTimeNumber());
        this.update(order);
        this.doProcessMerchantOrder(order);

        // 这里只扣除金额，账单记录在task中处理
        if(payPrice > 0){
            userRegisterService.execUpdateMoney(userId, payPrice, Constants.OPERATION_TYPE_SUBTRACT);
            // 更新缓存中用户余额，为外面更新准备
            user.setNowMoney(user.getNowMoney() - payPrice);

            // 用户余额记录
            EbUserBalanceRecord userBalanceRecord = new EbUserBalanceRecord();
            userBalanceRecord.setId(NumberGenerator.getLongSequenceNumber());
            userBalanceRecord.setCreateTime(DateUtils.getDateTimeNumber());
            userBalanceRecord.setUid(userId);
            userBalanceRecord.setLinkId(order.getOrderNo());
            userBalanceRecord.setLinkType(BalanceRecordConstants.BALANCE_RECORD_LINK_TYPE_ORDER);
            userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
            userBalanceRecord.setAmount(payPrice);
            userBalanceRecord.setBalance(user.getNowMoney());
            userBalanceRecord.setRemark(BalanceRecordConstants.BALANCE_RECORD_REMARK_ORDER + payPrice);
            userBalanceRecord.setMonth(Integer.parseInt(DateUtils.getYearMonthCurrentValue()));
            // 余额签名字段，金额保留2位小数，2023-08-30
//            StringBuilder sb = new StringBuilder(String.valueOf(userId));
//            sb.append(NumberFormatUtils.scaleAccuracy2(payPrice)).append(NumberFormatUtils.scaleAccuracy2(userBalanceRecord.getBalance()));
//            userBalanceRecord.setSign(MD5.sign(sb.toString(), md5Key, StringUtils.DEFAULT_CHARSET_UTF8));
            userBalanceRecord.setSign(PayUtils.acquireUserBalanceSign(userId, payPrice, userBalanceRecord.getBalance(), md5Key));
            this.insert(userBalanceRecord);
        }
    }

    private void doProcessMerchantOrder(EbOrder order){
        this.execute("update eb_merchant_order set pay_type=?, pay_channel=?, update_time=? where order_no=?"
                , new Object[]{order.getPayType(), order.getPayChannel(), DateUtils.getDateTimeNumber(), order.getOrderNo()});
    }


}
