package com.ishop.merchant.service;

import com.ishop.model.po.EbProductAttr;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ProductAttrServiceImpl extends BaseServiceImpl {

    /**
     * 删除已有商品规格
     * @param productId 商品ID
     * @param type 规格类型
     * @date 2023-08-02
     */
    public void execDeleteByProductIdAndType(long productId, int type){
        this.execute("update eb_product_attr set is_del=1 where product_id=? and type=?", new Object[]{productId, type});
    }

    /**
     * 根据属性类型，和商品ID，返回对应商品属性定义列表。
     * @param type
     * @param productId
     * @return
     * @date 2023-06-14
     */
    public List<EbProductAttr> queryProductAttrList(int type, long productId){
        EbProductAttr attr = new EbProductAttr();
        attr.setType(type);
        attr.setProductId(productId);
        attr.setIsDel(0);
        return this.select(attr);
    }
}
