package com.ishop.merchant.service;

import com.ishop.merchant.Constants;
import com.ishop.model.po.EbProductAttrValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ProductAttrValueServiceImpl extends BaseServiceImpl {

    /**
     * 删除已有规格属性值
     * @param productId 商品ID
     * @param type 规格类型
     * @date 2023-08-02
     */
    public void execDeleteByProductIdAndType(long productId, int type){
        this.execute("update eb_product_attr_value set is_del=1 where product_id=? and type=?", new Object[]{productId, type});
    }

    /**
     * 添加(退货)/扣减库存
     *
     * @param id            商品属性规格id
     * @param num           数量
     * @param operationType 类型：add—添加，sub—扣减，refund-退款添加库存
     * @param type          活动类型 0=商品
     * @return Boolean
     */
    public int execOperateStock(Integer id, Integer num, String operationType, Integer type, Integer version){
        Map<String, Object> param = new HashMap<>(4);
        StringBuilder sql = new StringBuilder("update eb_product_attr_value");
        if (operationType.equals(Constants.OPERATION_TYPE_QUICK_ADD)) {
            sql.append(" set stock=stock+:num");
            param.put("num", num);
            if (type > 0) {
                sql.append(",quota=quota+:quota");
                param.put("quota", num);
            }
        } else if (operationType.equals(Constants.OPERATION_TYPE_ADD)){
            sql.append(" set stock=stock+:num");
            sql.append(",sales=sales-:num");
            param.put("num", num);
            if (type > 0) {
                sql.append(",quota=quota+:quota");
                param.put("quota", num);
            }

        } else if (operationType.equals(Constants.OPERATION_TYPE_SUBTRACT)){
            sql.append(" set stock=stock-:num");
            sql.append(",sales=sales+:num");
            param.put("num", num);
            if(type == 0 || type == 4) { // 普通商品或者视频号商品
                // 扣减时加乐观锁保证库存不为负
//                updateWrapper.last(StrUtil.format("and (stock - {} >= 0)", num));
            }else if (type > 0) {
//                updateWrapper.setSql(StrUtil.format("quota = quota - {}", num));
//                // 扣减时加乐观锁保证库存不为负
//                updateWrapper.last(StrUtil.format("and (quota - {} >= 0)", num));
            }
            log.warn("注意：库存这里需要后续优化！");

        } else if (operationType.equals(Constants.OPERATION_TYPE_ACTIVITY_CREATE)){
            sql.append(" set stock=stock-:num");
            param.put("num", num);
//            updateWrapper.last(StrUtil.format("and (stock - {} >= 0)", num));

        } else {
            throw new UnsupportedOperationException("不支持的库存操作类型：" + operationType);
        }
        sql.append(", version=version+1");
//        sql.append(" where id=:id and type=:type and version=:version");
        sql.append(" where id=:id");
        param.put("id", id);
        return this.execute(sql.toString(), param);
    }

    /**
     * 根据id、类型查询。目前看只需要ID就行，其他两个参数无用！
     * @param id
     * @param productId
     * @param type
     * @return
     * @date 2023-07-06
     */
    public EbProductAttrValue queryByIdAndProductIdAndType(Integer id, Long productId, Integer type){
        EbProductAttrValue param = new EbProductAttrValue();
        param.setId(id);
        param.setProductId(productId);
        param.setType(type);
        param.setIsDel(0);
        List<EbProductAttrValue> list = this.select(param);
        if(!StringUtils.isEmptyList(list)){
            return list.get(0);
        }
        return null;
    }

    /**
     * 获取商品参数规格值集合。
     * @param type 类型：参加常量 {@linkplain com.ishop.merchant.ProductConstants}
     * @param productId
     * @return
     * @date 2023-06-14
     */
    public List<EbProductAttrValue> queryProductAttrValueList(int type, long productId){
        EbProductAttrValue attr = new EbProductAttrValue();
        attr.setType(type);
        attr.setProductId(productId);
        attr.setIsDel(0);
        return this.select(attr);
    }
}
