package com.ishop.merchant.service;

import com.ishop.model.po.EbProductBrand;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ProductBrandServiceImpl extends BaseServiceImpl {

    /**
     * 根据商品分类，关联查询品牌集合。
     * @param categoryId 商品分类
     * @param brandName 查询的品牌名称
     * @return
     * @date 2023-06-15
     */
    public GenericPager<EbProductBrand> queryPageBrandListByCategory(int categoryId, String brandName){
        Map<String, Object> parameters = new HashMap<>(2);
        StringBuilder sql = new StringBuilder(SQL_PAGE_BRAND_CATEGORY);
        parameters.put("cid", categoryId);

        if(StringUtils.isNotEmpty(brandName)){
            sql.append(" and pb.name like :name");
            parameters.put("name", StringUtils.CHAR_PERCENT + UrlUtils.decode(brandName) + StringUtils.CHAR_PERCENT);
        }
        sql.append(" order by pb.sort desc");
        return this.selectSplit(sql.toString(), parameters, new EbProductBrand());
    }

    private static final String SQL_PAGE_BRAND_CATEGORY = "SELECT pb.id,pb.name,pb.icon " +
            "FROM eb_product_brand pb right join eb_product_brand_category pbc on pb.id = pbc.bid " +
            "where pb.is_show = 1 and pb.is_del = 0 and pbc.cid=:cid";

    public void execInsertBrand(EbProductBrand brand, List<Object[]> brandCategoryList){
        this.insert(brand);
        if(!StringUtils.isEmptyList(brandCategoryList)){
            this.execBatchUpdate("insert into eb_product_brand_category(bid,cid) values(?,?)", brandCategoryList);
        }
    }

    public List<EbProductBrand> queryAllProductBrandList(){
        return this.select("select * from eb_product_brand where is_del=0 order by sort desc", new Object[]{}, new EbProductBrand());
    }

    /**
     * 获得下一个可用的最大ID。
     * @return
     * @date 2023-05-17
     */
    public int queryNextId(){
        int maxId = this.queryForInt(SQL_MAX_ID, new Object[]{});
        return maxId+1;
    }

    private static final String SQL_MAX_ID = "select max(id) from eb_product_brand";
}
