package com.ishop.merchant.service;

import com.ishop.model.po.EbProductCategory;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ProductCategoryServiceImpl extends BaseServiceImpl {

    /**
     * 是否有品牌关联分类
     * @param categoryId
     * @return
     */
    public int queryHasBrand(int categoryId){
        return this.queryForInt("select count(*) from eb_product_brand_category where cid=?", new Object[]{categoryId});
    }

    /**
     * 查找给定节点下是否存在子类集合。
     * @param pid 父节点id
     * @param level 层次级别，最大3级。
     * @return
     * @date 2023-06-07
     */
    public List<EbProductCategory> queryChildrenList(int pid, int level){
        EbProductCategory category = new EbProductCategory();
        category.setPid(pid);
        category.setLevel(level);
        category.setIsDel(0);
        return this.select(category);
    }

    /**
     * 获得下一个可用的最大ID。
     * @return
     * @date 2023-05-17
     */
    public int queryNextId(){
        int maxId = this.queryForInt(SQL_MAX_ID, new Object[]{});
        return maxId+1;
    }

    private static final String SQL_MAX_ID = "select max(id) from eb_product_category";
}
