package com.ishop.merchant.service;

import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbProductGuarantee;
import com.ishop.model.po.EbProductGuaranteeGroup;
import com.ishop.model.vo.GuaranteeGroupVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ProductGuaranteeServiceImpl extends BaseServiceImpl {

    /**
     * 根据保障ID集合，查询集合。
     * @param idList
     * @return
     * @date 2023-07-04
     */
    public List<EbProductGuarantee> queryListByIds(List<Integer> idList){
        Map<String, Object> parameter = new HashMap<>(2);
        parameter.put("ids", idList);
        return this.select("select * from eb_product_guarantee where id in (:ids)", parameter, new EbProductGuarantee());
    }

    /**
     * 获得商户保障服务列表（分组）
     * @param merId
     * @return
     * @date 2023-06-21
     */
    public List<GuaranteeGroupVo> queryMerchantGroupGuaranteeList(int merId){
        EbProductGuaranteeGroup guaranteeGroup = new EbProductGuaranteeGroup();
        guaranteeGroup.setMerId(merId);
        guaranteeGroup.setIsDel(0);
        List<EbProductGuaranteeGroup> productGuaranteeGroups = this.select(guaranteeGroup);
        if(StringUtils.isEmptyList(productGuaranteeGroups)){
            return new ArrayList(1);
        }

        List<Integer> groupIds = new ArrayList<>(8);
        for(EbProductGuaranteeGroup e : productGuaranteeGroups){
            groupIds.add(e.getId());
        }

        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("groupIds", groupIds);
        List<Map<String, Object>> list = this.queryListObjectWhereIn("select * from eb_merchant_product_guarantee_group where group_id in (:groupIds)", parameterSource);

        List<GuaranteeGroupVo> groupVoList = new ArrayList<>(productGuaranteeGroups.size());
        for(EbProductGuaranteeGroup group : productGuaranteeGroups){
            groupVoList.add(VoUtils.transferTo(group));
        }
        if(!StringUtils.isEmptyList(list)){
            for(GuaranteeGroupVo vo : groupVoList){
                int groupId = 0;
                for(Map<String, Object> map : list){
                    groupId = Integer.parseInt(map.get("group_id").toString());
                    if(groupId == vo.getId()){
                        vo.add(VoUtils.acquireMerProdGuaranteeGroup(map));
                    }
                }
            }
        }
        return groupVoList;
    }

    public List<EbProductGuarantee> queryProductGuaranteeList(Integer isShow){
        if(isShow == null){
            return this.select("select * from eb_product_guarantee where is_del=0 order by sort desc", new Object[]{}, new EbProductGuarantee());
        } else {
            return this.select("select * from eb_product_guarantee where is_del=0 and is_show=? order by sort desc", new Object[]{isShow}, new EbProductGuarantee());
        }
    }
}
