package com.ishop.merchant.service;

import com.ishop.merchant.ProductConstants;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 商品，用户收藏，数据操作。
 * @date 2023-08-02
 */
@Service
public class ProductRelationServiceImpl extends BaseServiceImpl {

    /**
     * 删除用户收藏记录中，关于该商品的记录。
     * @param productId
     * @date 2023-08-02
     */
    public void execDeleteProduct(long productId){
        this.execute("delete from eb_product_relation where product_id=?", new Object[]{productId});
    }

    /**
     * 查询给定人员，收藏商品数量。
     * @param userId 用户ID
     * @return
     * @date 2023-06-30
     */
    public int queryProductCollectionCount(long userId){
//        EbProductRelation relation = new EbProductRelation();
//        relation.setUid(userId);
//        relation.setType();
        return this.queryForInt(SQL_COLLECTION_COUNT, new Object[]{userId, ProductConstants.PRODUCT_RELATION_TYPE_COLLECT});
    }

    private static final String SQL_COLLECTION_COUNT = "select count(id) from eb_product_relation where uid=? and type=?";
}
