package com.ishop.merchant.service;

import com.ishop.merchant.ProductConstants;
import com.ishop.model.vo.ProductDetailReplyVo;
import com.ishop.model.vo.ProductReplayCountVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class ProductReplyServiceImpl extends BaseServiceImpl {

    /**
     * H5商品详情评论信息
     * @param productId 商品ID
     * @return
     * @date 2023-07-04
     */
    public ProductDetailReplyVo queryH5ProductReply(long productId){
        ProductDetailReplyVo vo = new ProductDetailReplyVo();
        // 评论总数
        int sumCount = getReplyCountByScope(ProductConstants.PRODUCT_REPLY_TYPE_ALL, productId);
        if (sumCount == 0) {
            vo.setSumCount(0);
            vo.setReplyChance("0");
            return vo;
        }
        System.out.println("还未实现代码（商品评价详情）！");
        return vo;
    }

    private int getReplyCountByScope(String type, long productId){
        StringBuilder sql = new StringBuilder("select count(*) from eb_product_reply where product_id=:productId and is_del=0");
        if(StringUtils.isNotEmpty(type)){
            if(type.equals(ProductConstants.PRODUCT_REPLY_TYPE_GOOD)){
                sql.append(" and star=5");
            } else if(type.equals(ProductConstants.PRODUCT_REPLY_TYPE_POOR)){
                sql.append(" and star=1");
            } else if (type.equals(ProductConstants.PRODUCT_REPLY_TYPE_MEDIUM)) {
                sql.append(" and (star>1 and star<5)");
            } else if (type.equals(ProductConstants.PRODUCT_REPLY_TYPE_ALL)) {
                // 查询所有星级
            }
        }
        Map<String, Object> parameter = new HashMap<>(2);
        parameter.put("productId", productId);
        return this.queryForInt(sql.toString(), parameter);
    }

    /**
     * 返回手机端商品评论统计
     * @return
     * @date 2023-07-04
     */
    public ProductReplayCountVo queryH5ReplyCount(long productId){
        // 评论总数
//        Integer sumCount = getCountByScore(productId, ProductConstants.PRODUCT_REPLY_TYPE_ALL);
        Integer sumCount = 0;
//        // 好评总数
//        Integer goodCount = getCountByScore(productId, ProductConstants.PRODUCT_REPLY_TYPE_GOOD);
        Integer goodCount = 0;
//        // 中评总数
//        Integer mediumCount = getCountByScore(productId, ProductConstants.PRODUCT_REPLY_TYPE_MEDIUM);
//        // 差评总数
//        Integer poorCount = getCountByScore(productId, ProductConstants.PRODUCT_REPLY_TYPE_POOR);
        // 好评率
        String replyChance = "0";
        if (sumCount > 0 && goodCount > 0) {
            replyChance = String.format("%.2f", ((goodCount.doubleValue() / sumCount.doubleValue())));
        }
        // 评分星数 = 总星数/评价数
        Integer replyStar = 0;
//        if (sumCount > 0) {
//            replyStar = getSumStar(productId);
//            BigDecimal divide = new BigDecimal(replyStar).divide(new BigDecimal(sumCount.toString()), 0, BigDecimal.ROUND_DOWN);
//            replyStar = divide.intValue();
//        }
        return new ProductReplayCountVo(sumCount, goodCount, 0, 0, replyChance, replyStar);
    }
}
