package com.ishop.merchant.service;

import com.ishop.model.po.EbProductRule;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service
public class ProductRuleServiceImpl extends BaseServiceImpl {

    private final Sorts.Sort idSort = Sorts.DESC().setField("id");

    /**
     * 查询是否存在对应商户的规格记录
     * @param merId 商户ID
     * @param ruleName 规格名称
     * @return
     * @date 2023-07-31
     */
    public boolean queryExistRuleName(int merId, String ruleName){
        long size = this.sqlMathQuery("select count(id) total from eb_product_rule where mer_id=? and rule_name=?", new Object[]{merId, ruleName}, Long.class);
        return size > 0;
    }

    /**
     * 分页返回商户端管理的：商品规格列表
     * @param merId
     * @param keywords
     * @return
     */
    public GenericPager<EbProductRule> queryPageRuleList(Integer merId, String keywords){
        EbProductRule param = new EbProductRule();
        if(merId != null){
            param.setMerId(merId);
        }
        if(StringUtils.isNotEmpty(keywords)){
            param.setRuleName(StringUtils.CHAR_PERCENT + keywords + StringUtils.CHAR_PERCENT);
        }
        return this.selectSplit(param, idSort);
    }
}
