package com.ishop.merchant.service;

import com.ishop.model.po.EbShippingTemplates;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 运费模板管理数据库操作。
 * @author 时克英
 * @date 2023-06-21
 */
@Service
public class ShippingTemplateServiceImpl extends BaseServiceImpl {

    public GenericPager<EbShippingTemplates> queryPageShippingTemplateList(int merId, String keywords){
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);
        Map<String, Object> parameter = new HashMap<>(2);
        if(merId > 0){
            sql.append(" and mer_id=:merId");
            parameter.put("merId", merId);
        }
        if(StringUtils.isNotEmpty(keywords)){
            sql.append(" and name like :keywords");
            parameter.put("keywords", StringUtils.CHAR_PERCENT + keywords + StringUtils.CHAR_PERCENT);
        }
        sql.append(" order by sort desc");
        return this.selectSplit(sql.toString(), parameter, new EbShippingTemplates());
    }

    private static final String SQL_PAGE_LIST = "select * from eb_shipping_templates where 1=1";
}
