package com.ishop.merchant.service;

import com.ishop.model.po.EbUserAddress;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserAddressServiceImpl extends BaseServiceImpl {

    /**
     * 新增一个用户地址。
     * @param address
     * @return 返回记录ID
     * @date 2023-07-08
     */
    public Long execInsertUserAddress(EbUserAddress address){
        address.setId(NumberGenerator.getLongSequenceNumber());
        address.setCreateTime(DateUtils.getDateTimeNumber());
        if(address.getIsDefault().intValue() == 1){
            // 如果设置了默认地址，需要取消之前已有的默认
            this.execCancelDefault(address.getUid());
        }
        this.insert(address);
        return address.getId();
    }

    private void execCancelDefault(long userId){
        this.execute("update eb_user_address set is_default=0 where uid=?", new Object[]{userId});
    }

    /**
     * 获取用户地址列表。
     * @param userId
     * @return
     * @date 2023-07-08
     */
    public List<EbUserAddress> queryUserAllAddressList(long userId){
//        EbUserAddress address = new EbUserAddress();
//        address.setUid(userId);
//        address.setIsDel(0);
        return this.select("select * from eb_user_address where uid=? and is_del=0 order by is_default desc", new Object[]{userId}, new EbUserAddress());
    }
}
