package com.ishop.merchant.service;

import com.ishop.merchant.BalanceRecordConstants;
import com.ishop.model.po.EbUserBalanceRecord;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service
public class UserBalanceServiceImpl extends BaseServiceImpl {

    private final Sorts.Sort timeSort = Sorts.DESC().setField("create_time");

    /**
     * 查询个人余额变动列表。
     * @param recordType 记录类型：all-全部，expenditure-支出，income-收入，recharge-充值
     * @param userId
     * @return
     * @date 2023-09-13
     */
    public GenericPager queryPageBalanceList(String recordType, long userId){
        EbUserBalanceRecord param = new EbUserBalanceRecord();
        param.setUid(userId);
//        if(StringUtils.isNotEmpty(recordType)){
//            param.setLinkType(recordType);
//        }
        if(recordType.equals("expenditure")){
            param.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
        } else if(recordType.equals("income")){
            param.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        } else if(recordType.equals("recharge")) {
            param.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
            param.setLinkType(BalanceRecordConstants.BALANCE_RECORD_LINK_TYPE_RECHARGE);
        }
        return this.selectSplit(param, timeSort);
    }

    /**
     * 统计用户账户，余额充值总金额
     * @param userId
     * @return
     */
    public double queryTotalRechargeRecord(long userId){
        Double total = this.queryForObject(SQL_TOTAL_RECHARGE, new Object[]{userId}, Double.class);
        if(total == null){
            return 0;
        }
        return NumberFormatUtils.scaleAccuracy2(total);
    }

    /**
     * 统计用户账户，余额消费总金额
     * @param userId
     * @return
     * @date 2023-09-09
     */
    public double queryTotalMonetaryRecord(long userId){
        Double total = this.queryForObject(SQL_TOTAL_MONETARY, new Object[]{userId}, Double.class);
        if(total == null){
            return 0;
        }
        return NumberFormatUtils.scaleAccuracy2(total);
    }

    private static final String SQL_PAGE_LIST = "";
    private static final String SQL_TOTAL_MONETARY = "select sum(amount) total from eb_user_balance_record where uid=? and link_type='order' and type=2";
    private static final String SQL_TOTAL_RECHARGE = "select sum(amount) total from eb_user_balance_record where uid=? and link_type='recharge' and type=1";
}
