package com.ishop.merchant.service;

import com.ishop.merchant.BrokerageConstants;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service
public class UserBrokerageServiceImpl extends BaseServiceImpl {

    /**
     * 获取已结算佣金
     * @param userId
     * @return
     */
    public double querySettledCommission(long userId){
        Double d = this.queryForObject(SQL_USER_COMPLETE_TOTAL, new Object[]{userId, BrokerageConstants.BROKERAGE_RECORD_LINK_TYPE_WITHDRAW}, Double.class);
        return d == null? 0: d;
    }

    /**
     * 获取（个人）冻结期佣金
     * @param userId
     * @return
     * @date 2023-09-19
     */
    public double queryFreezePrice(long userId){
        // BrokerageConstants.BROKERAGE_RECORD_LINK_TYPE_ORDER, BrokerageConstants.BROKERAGE_RECORD_STATUS_CREATE
        Double d = this.queryForObject(SQL_USER_FREEZE_TOTAL, new Object[]{userId, BrokerageConstants.BROKERAGE_RECORD_LINK_TYPE_ORDER}, Double.class);
        return d == null? 0: d;
    }

    private static final String SQL_USER_FREEZE_TOTAL = "select sum(price) total from eb_user_brokerage_record where uid=? and link_type=? and (status=1 or status=2)";
    private static final String SQL_USER_COMPLETE_TOTAL = "select sum(price) total from eb_user_brokerage_record where uid=? and link_type=? and (status=3)";
}
