package com.ishop.merchant.support;

import com.iplatform.base.callback.UserProfileCallback;
import com.iplatform.base.pojo.UserInfoRequest;
import com.iplatform.model.po.S_user_core;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 平台修改资料时，商户端需要更新。
 * @date 2023-08-03
 */
public class MerchantProfileCallback implements UserProfileCallback {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onUpdateUser(S_user_core user, UserInfoRequest request) {
        logger.info("配置了商户，更新用户资料：" + request.getRealName());
    }

    @Override
    public boolean supportMultiple() {
        return false;
    }
}
