package com.ishop.merchant.support;

import com.iplatform.base.WechatConstants;
import com.iplatform.core.BeanContextAware;
import com.ishop.merchant.service.OrderServiceImpl;
import com.ishop.model.po.EbOrder;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.OrderStatusQuery;
import com.walker.pay.PayType;
import com.walker.pay.wechat.WechatV2PayEngineProvider;
import org.springframework.web.client.RestTemplate;

/**
 * 微信支付V2版本在电商模块中的实现。
 * @author 时克英
 * @date 2023-08-30
 */
public class WechatV2PlatformPayEngine extends WechatV2PayEngineProvider {

    public WechatV2PlatformPayEngine(RestTemplate restTemplate) {
        super(restTemplate);
    }

    @Override
    protected OrderStatusQuery acquireOrderStatusQuery(Order order) {
//        if(StringUtils.isEmpty(orderId)){
//            throw new IllegalArgumentException("orderId is required!");
//        }
        // 这里 orderId 就是 orderNo
//        EbOrder order = this.acquireOrderService().queryOrder(orderId);
//        if(order == null){
//            throw new PlatformRuntimeException("订单不存在，orderId={}" + order);
//        }
//        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
//            throw new PlatformRuntimeException("订单已取消");
//        }
//        S_pay_order platformOrder = this.acquireOrderService().get(new S_pay_order(order.getId()));
//        if(platformOrder == null){
//            logger.error("平台底层订单不存在，S_pay_order = null, id = " + order.getId());
//            throw new PlatformRuntimeException("平台底层订单不存在，S_pay_order = null, id = " + order.getId(), null);
//        }
//        int payType = platformOrder.getPay_type();

        // 为了获取 orderNo，业务中使用另外字符串作为订单标识。2023-08-30
        EbOrder ebOrder = this.acquireOrderService().get(new EbOrder(order.getId()));

        PayType payType = order.getPayType();
        String appId = null;
        String mchId = null;
        String apiKey = null;

        OrderStatusQuery query = new OrderStatusQuery();
        query.setOrderId(order.getId());

        if(payType == PayType.OfficialAccount || payType == PayType.H5){
            appId = this.getArgumentVariable(WechatConstants.WECHAT_PUBLIC_APPID).getStringValue();
            mchId = this.getArgumentVariable(WechatConstants.WECHAT_PAY_PUBLIC_MCHID).getStringValue();
            apiKey = this.getArgumentVariable(WechatConstants.WECHAT_PAY_PUBLIC_KEY).getStringValue();
        } else {
            throw new UnsupportedOperationException("其他类型订单为实现参数获取，payType = " + payType);
        }
        query.setAppId(appId);
        query.setApiKey(apiKey);
        query.setTradeNo(ebOrder.getOrderNo());
        query.setMerchantId(mchId);
        return query;
    }

    private Variable getArgumentVariable(String key){
        return BeanContextAware.getBeanByType(ArgumentsManager.class).getVariable(key);
    }

    private OrderServiceImpl acquireOrderService(){
        return BeanContextAware.getBeanByType(OrderServiceImpl.class);
    }
}
