package com.ishop.merchant.util;

import com.ishop.model.po.EbCityRegion;
import com.ishop.model.vo.CityTreeVo;
import com.ishop.model.vo.CityVo;
import com.walker.cache.Cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CityUtils {

    public static final void buildTree(List<CityTreeVo> cityTreeVoList, List<EbCityRegion> data, Cache cache){
        CityTreeVo cityTreeVo = null;
        int regionType = 0;
        Map<Integer, CityTreeVo> tempMap = new HashMap<>(data.size());

        for(EbCityRegion cityRegion : data){
            // 每条数据线加入到缓存
            cityTreeVo = CityUtils.transferTo(cityRegion);
            cache.put(String.valueOf(cityRegion.getRegionId()), cityTreeVo);
            tempMap.put(cityRegion.getRegionId(), cityTreeVo);

            cityTreeVoList.add(cityTreeVo);
        }

        for(Iterator<CityTreeVo> it = cityTreeVoList.iterator(); it.hasNext();){
            cityTreeVo = it.next();
            regionType = cityTreeVo.getRegionType().intValue();
            // 第一级节点：省份
            if(regionType == CityVo.TYPE_PROVINCE){
                continue;
            }

            // 第二级节点：城市
            if(regionType == CityVo.TYPE_CITY){
                tempMap.get(cityTreeVo.getParentId()).addChild(cityTreeVo);
                it.remove();
                continue;
            }

            // 第三级节点：区县
            if(regionType == CityVo.TYPE_DISTRICT){
                tempMap.get(cityTreeVo.getParentId()).addChild(cityTreeVo);
                it.remove();
                continue;
            }
            // 第四级节点：街道
            if(regionType == CityVo.TYPE_STREET){
                tempMap.get(cityTreeVo.getParentId()).addChild(cityTreeVo);
                it.remove();
                continue;
            }
        }
        tempMap.clear();
    }

    public static final CityTreeVo transferTo(EbCityRegion cityRegion){
        CityTreeVo vo = new CityTreeVo();
        vo.setRegionId(cityRegion.getRegionId());
        vo.setParentId(cityRegion.getParentId());
        vo.setRegionName(cityRegion.getRegionName());
        vo.setRegionType(cityRegion.getRegionType());
        int regionType = cityRegion.getRegionType().intValue();
        if(regionType == CityVo.TYPE_PROVINCE || regionType == CityVo.TYPE_CITY){
            vo.setIsChild(true);
        }
        return vo;
    }
}
