package com.ishop.merchant.util;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class ImageUtils {

    /**
     * 把给定的图片路径集合，分别拼接上前缀，在商品轮播图字段中常用。
     * @param images ["img/001/demo.png", "img/002/demo.png", ""]
     * @param prefix 前缀，如：http://localhost:8082/admin/ 就是方法 getCdnUrl()
     * @return 返回路径中统一拼接前缀
     * @date 2023-06-17
     */
    public static final String combineMultiImageUrl(String images, String prefix){
        List<String> combinedImageList = new ArrayList<>(4);
        try {
            ArrayNode nodes = JsonUtils.toJsonArray(images);
            for(int i=0; i< nodes.size(); i++){
//                nodes.set(i, prefix + nodes.get(i).asText());
                combinedImageList.add(prefix + nodes.get(i).asText());
            }
            return JsonUtils.objectToJsonString(combinedImageList);
        } catch (Exception e) {
            throw new RuntimeException("图片集合转json数组错误:" + images, e);
        }
    }

    /**
     * 把数组中多个图片路径，替换后，重新组成json数组。清除掉前缀。
     * @param images ["http://local/a.png","http://local/b.png"]
     * @param prefix 前缀
     * @return 替换后，消除前缀。
     * @date 2023-07-20
     */
    public static final String clearCdnMultiImageUrl(String images, String prefix){
        List<String> clearImageList = new ArrayList<>(4);
        try {
            ArrayNode nodes = JsonUtils.toJsonArray(images);
            for(int i=0; i< nodes.size(); i++){
                String img = nodes.get(i).asText().replace(prefix, StringUtils.EMPTY_STRING);
                clearImageList.add(img);
            }
            return JsonUtils.objectToJsonString(clearImageList);
        } catch (Exception e) {
            throw new RuntimeException("图片集合转json数组错误:" + images, e);
        }
    }
}
