package com.ishop.merchant.util;

import com.ishop.merchant.util.cache.MerProductCateSortComparator;
import com.ishop.merchant.util.cache.ProductCategorySortComparator;
import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProductCategoryUtils {

    protected static Logger logger = LoggerFactory.getLogger(ProductCategoryUtils.class);

    /**
     * 根据商品分类对象集合（平台）返回分类ID集合。
     * @param categoryList
     * @return
     * @date 2023-07-23
     */
    public static final List<Integer> acquireCategoryIdList(List<EbProductCategory> categoryList){
        if(StringUtils.isEmptyList(categoryList)){
            return null;
        }
        List<Integer> list = new ArrayList<>(categoryList.size());
        for(EbProductCategory category : categoryList){
            list.add(category.getId());
        }
        return list;
    }

    public static final List<ProductCategoryVo> acquireListTree(List<EbMerchantProductCategory> allTree, MerProductCateSortComparator sortComparator){
        // 重新排序
        Collections.sort(allTree, sortComparator);
        //
        List<ProductCategoryVo> treeList = new ArrayList<>();
        if(allTree.size() == 0){
            return treeList;
        }
        //
        for (EbMerchantProductCategory category : allTree) {
            treeList.add(new ProductCategoryVo(category));
        }
        return buildTree(treeList);
    }

    /**
     * 获取平台商品分类树列表。
     * @param allTree
     * @param sortComparator
     * @return
     * @date 2023-06-01
     */
    public static final List<ProductCategoryVo> acquireListTree(List<EbProductCategory> allTree, ProductCategorySortComparator sortComparator){
        // 重新排序
        Collections.sort(allTree, sortComparator);
        //
        List<ProductCategoryVo> treeList = new ArrayList<>();
        if(allTree.size() == 0){
            return treeList;
        }

        //
        for (EbProductCategory category : allTree) {
            treeList.add(new ProductCategoryVo(category));
        }

//        Map<Integer, ProductCategoryVo> map = new HashMap<>(treeList.size());
//        //ID 为 key 存储到map 中
//        for (ProductCategoryVo categoryTreeVo : treeList) {
//            map.put(categoryTreeVo.getId(), categoryTreeVo);
//        }
//
//        List<ProductCategoryVo> list = new ArrayList<>();
//        ProductCategoryVo parentTree = null;
//        for (ProductCategoryVo tree : treeList) {
//            //子集ID返回对象，有则添加。
//            parentTree = map.get(tree.getPid());
//            if (parentTree != null) {
//                parentTree.getChildList().add(tree);
//            } else {
//                list.add(tree);
//            }
//        }
//        return list;
        return buildTree(treeList);
    }

    private static List<ProductCategoryVo> buildTree(List<ProductCategoryVo> treeList){
        Map<Integer, ProductCategoryVo> map = new HashMap<>(treeList.size());
        //ID 为 key 存储到map 中
        for (ProductCategoryVo categoryTreeVo : treeList) {
            map.put(categoryTreeVo.getId(), categoryTreeVo);
        }

        List<ProductCategoryVo> list = new ArrayList<>();
        ProductCategoryVo parentTree = null;
        for (ProductCategoryVo tree : treeList) {
            //子集ID返回对象，有则添加。
            parentTree = map.get(tree.getPid());
            if (parentTree != null) {
                parentTree.getChildList().add(tree);
            } else {
                list.add(tree);
            }
        }
        return list;
    }
}
