package com.ishop.merchant.util;

import com.ishop.merchant.ProductConstants;
import com.ishop.model.po.EbArticle;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.po.EbCoupon;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbMerchantProductGuaranteeGroup;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductGuarantee;
import com.ishop.model.po.EbProductGuaranteeGroup;
import com.ishop.model.po.EbUserToken;
import com.ishop.model.request.ArticleRequest;
import com.ishop.model.vo.ArticleCategoryVo;
import com.ishop.model.vo.ArticleVo;
import com.ishop.model.vo.CouponFrontVo;
import com.ishop.model.vo.GuaranteeGroupVo;
import com.ishop.model.vo.MerchantConfigInfoVo;
import com.ishop.model.vo.OrderDetailFrontVo;
import com.ishop.model.vo.OrderInvoiceDetailVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformMerDetailVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.ishop.model.vo.ProductAddVo;
import com.ishop.model.vo.ProductGuaranteeVo;
import com.ishop.model.vo.ProductInfoVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;

import java.util.Map;

public class VoUtils {

    public static final EbOrderInvoiceDetail acquireOrderInvoiceDetail(EbOrderDetail orderDetail){
        EbOrderInvoiceDetail vo = new EbOrderInvoiceDetail();
        vo.setId(NumberGenerator.getLongSequenceNumber());
        vo.setCreateTime(DateUtils.getDateTimeNumber());
//        vo.setInvoiceId(orderDetail.geti);
        vo.setUpdateTime(vo.getCreateTime());
        vo.setImage(orderDetail.getImage());
        vo.setAttrValueId(orderDetail.getAttrValueId());
        vo.setProductId(orderDetail.getProductId());
        vo.setProductName(orderDetail.getProductName());
        vo.setSku(orderDetail.getSku());
        return vo;
    }

    public static final EbUserToken acquireEbUserToken(int type, long userId, String token){
        EbUserToken userToken = new EbUserToken();
        userToken.setId(NumberGenerator.getLongSequenceNumber());
        userToken.setCreateTime(DateUtils.getDateTimeNumber());
        userToken.setIsDel(0);
        userToken.setType(type);
        userToken.setUid(userId);
        userToken.setToken(token);
        return userToken;
    }

    public static final PlatformMerDetailVo acquirePlatformMerDetailVo(EbMerchant merchant){
        PlatformMerDetailVo vo = new PlatformMerDetailVo();
        vo.setIsSelf(merchant.getIsSelf().intValue() == 1);
        vo.setIsRecommend(merchant.getIsRecommend().intValue() == 1);
        vo.setAddressDetail(merchant.getAddressDetail());
        vo.setAdminId(merchant.getAdminId());
        vo.setCreateType(merchant.getCreateType());
        vo.setCategoryId(merchant.getCategoryId());
        vo.setHandlingFee(merchant.getHandlingFee());
        vo.setId(merchant.getId());
        vo.setKeywords(merchant.getKeywords());
        vo.setLatitude(merchant.getLatitude());
        vo.setLongitude(merchant.getLongitude());
        vo.setName(merchant.getName());
        vo.setPhone(merchant.getPhone());
        vo.setProductSwitch(merchant.getProductSwitch().intValue() == 1);
        vo.setQualificationPicture(merchant.getQualificationPicture());
        vo.setRealName(merchant.getRealName());
        vo.setRemark(merchant.getRemark());
        vo.setSort(merchant.getSort());
        vo.setStarLevel(merchant.getStarLevel());
        vo.setTypeId(merchant.getTypeId());
        vo.setAccount(merchant.getPhone());
        return vo;
    }

    public static final OrderInvoiceDetailVo acquireOrderInvoiceDetailVo(EbOrderInvoiceDetail detail){
        OrderInvoiceDetailVo vo = new OrderInvoiceDetailVo();
        vo.setId(detail.getId());
        vo.setInvoiceId(detail.getInvoiceId());
        vo.setNum(detail.getNum());
        vo.setImage(detail.getImage());
        vo.setAttrValueId(detail.getAttrValueId());
        vo.setProductId(detail.getProductId());
        vo.setSku(detail.getSku());
        vo.setCreateTime(DateUtils.toShowDate(detail.getCreateTime()));
        return vo;
    }

    public static final OrderInvoiceVo acquireOrderInvoiceVo(EbOrderInvoice invoice){
        OrderInvoiceVo vo = new OrderInvoiceVo();
        vo.setId(invoice.getId());
        vo.setOrderNo(invoice.getOrderNo());
        vo.setMerId(invoice.getMerId());
        vo.setUid(invoice.getUid());
        vo.setExpressCode(invoice.getExpressCode());
        vo.setExpressName(invoice.getExpressName());
        vo.setCreateTime(DateUtils.toShowDate(invoice.getCreateTime()));
        vo.setTotalNum(invoice.getTotalNum());
        vo.setTrackingNumber(invoice.getTrackingNumber());
        return vo;
    }

    public static final OrderDetailFrontVo acquireOrderDetailFrontVo(EbOrderDetail detail){
        OrderDetailFrontVo vo = new OrderDetailFrontVo();
        vo.setId(detail.getId());
        vo.setMerId(detail.getMerId());
        vo.setImage(detail.getImage());
        vo.setAttrValueId(detail.getAttrValueId());
        vo.setPayNum(detail.getPayNum());
        vo.setPrice(detail.getPrice());
        vo.setApplyRefundNum(detail.getApplyRefundNum());
        vo.setDeliveryNum(detail.getDeliveryNum());
        vo.setPayPrice(detail.getPayPrice());
        vo.setProductName(detail.getProductName());
        vo.setProductId(detail.getProductId());
        vo.setRefundNum(detail.getRefundNum());
        vo.setSku(detail.getSku());
        return vo;
    }

    public static final PlatformOrderDetailVo acquirePlatformOrderDetailVo(EbOrder order, EbMerchantOrder merchantOrder){
        PlatformOrderDetailVo vo = new PlatformOrderDetailVo();
        vo.setClerkId(merchantOrder.getClerkId());
        vo.setCreateTime(DateUtils.toShowDate(order.getCreateTime()));
        vo.setCancelStatus(order.getCancelStatus());
        vo.setOrderNo(order.getOrderNo());
        vo.setCommissionCharge(merchantOrder.getCommissionCharge());
        vo.setCouponPrice(order.getCouponPrice());
        vo.setDeliveryType(merchantOrder.getDeliveryType());
        vo.setFirstBrokerage(merchantOrder.getFirstBrokerage());
        vo.setGainIntegral(order.getGainIntegral());
        vo.setCouponPrice(order.getCouponPrice());
        vo.setIntegralPrice(order.getIntegralPrice());
        vo.setIsLogoff(order.getIsUserDel().intValue() == 1);
        vo.setIsMerchantDel(order.getIsMerchantDel().intValue() == 1);
        vo.setLevel(order.getLevel());
        vo.setIsSplit(merchantOrder.getIsSplitDelivery().intValue() == 1);
        vo.setMerId(merchantOrder.getMerId());
        vo.setOutTradeNo(order.getOutTradeNo());
        vo.setPaid(order.getPaid().intValue() == 1);
        vo.setPayChannel(order.getPayChannel());
        vo.setPayPostage(order.getPayPostage());
        vo.setPayPrice(order.getPayPrice());
        if(vo.getPaid()){
            vo.setPayTime(DateUtils.toShowDate(order.getPayTime()));
        }
        vo.setPayType(order.getPayType());
        vo.setPhone(merchantOrder.getUserPhone());
        vo.setProTotalPrice(order.getProTotalPrice());
        vo.setRefundStatus(order.getRefundStatus());
        vo.setSecondBrokerage(merchantOrder.getSecondBrokerage());
        vo.setShippingType(merchantOrder.getShippingType());
        vo.setStatus(order.getStatus());
        vo.setTotalNum(order.getTotalNum());
        vo.setTotalPostage(order.getTotalPostage());
        vo.setTotalPrice(order.getTotalPrice());
        vo.setType(order.getType());
        vo.setUid(order.getUid());
        vo.setUseIntegral(order.getUseIntegral());
        vo.setUserAddress(merchantOrder.getUserAddress());
        vo.setUserRemark(merchantOrder.getUserRemark());
        vo.setVerifyCode(merchantOrder.getVerifyCode());
        vo.setMerchantRemark(merchantOrder.getMerchantRemark());
        return vo;
    }

    public static final PlatformOrderVo acquirePlatformOrderVo(EbOrder order){
        PlatformOrderVo vo = new PlatformOrderVo();
        vo.setOrderNo(order.getOrderNo());
        vo.setCancelStatus(order.getCancelStatus());
        vo.setCreateTime(DateUtils.toShowDate(order.getCreateTime()));
        vo.setIsMerchantDel(order.getIsMerchantDel().intValue() == 1);
        vo.setIsUserDel(order.getIsUserDel().intValue() == 1);
        vo.setLevel(order.getLevel());
        vo.setPayPrice(order.getPayPrice());
        vo.setPayType(order.getPayType());
        vo.setRefundStatus(order.getRefundStatus());
        vo.setStatus(order.getStatus());
        vo.setType(order.getType());
        return vo;
    }

    /**
     * 添加文字转换成数据库对象。
     * @param vo
     * @param cdnUrl
     * @return
     */
    public static final EbArticle acquireEbArticle(ArticleRequest vo, String cdnUrl){
        EbArticle article = new EbArticle();
        article.setId(vo.getId());
        article.setCreateTime(DateUtils.getDateTimeNumber());
        article.setUpdateTime(article.getCreateTime());
        article.setIsDel(0);
        article.setAuthor(vo.getAuthor());
        article.setTitle(vo.getTitle());
        article.setCid(vo.getCid());
        article.setSort(vo.getSort());
//        article.setStatus(vo.get);
        article.setIsBanner(vo.getIsBanner()? 1 : 0);
        article.setIsHot(vo.getIsHot()? 1 : 0);
        article.setContent(vo.getContent());
        article.setSynopsis(vo.getSynopsis());
        article.setCover(vo.getCover());
        return article;
    }

    public static final ArticleVo acquireArticleVo(EbArticle article, String cdnUrl, boolean needDetail){
        ArticleVo vo = new ArticleVo();
        vo.setId(article.getId());
        vo.setAuthor(article.getAuthor());
        vo.setCid(article.getCid());
        if(StringUtils.isNotEmpty(article.getCover())){
            vo.setCover(cdnUrl + article.getCover());
        }
        vo.setSort(article.getSort());
        vo.setStatus(article.getStatus().intValue() == 1);
        vo.setTitle(article.getTitle());
        vo.setCreateTime(DateUtils.toShowDate(article.getCreateTime()));
        vo.setIsBanner(article.getIsBanner().intValue() == 1);
        vo.setIsHot(article.getIsHot().intValue() == 1);
        vo.setVisit(article.getVisit());
        if(needDetail){
            vo.setSynopsis(article.getSynopsis());
            vo.setContent(article.getContent());
        }
        return vo;
    }

    public static final ArticleCategoryVo acquireArticleCategoryVo(EbArticleCategory category, String cdnUrl){
        ArticleCategoryVo vo = new ArticleCategoryVo();
        vo.setId(category.getId());
        vo.setName(category.getName());
        if(StringUtils.isNotEmpty(category.getIcon())){
            vo.setIcon(cdnUrl + category.getIcon());
        }
        vo.setSort(category.getSort());
        vo.setStatus(category.getStatus().intValue() == 1);
        return vo;
    }

    public static final CouponFrontVo acquireCouponFrontVo(EbCoupon coupon){
        CouponFrontVo vo = new CouponFrontVo();
        vo.setId(coupon.getId());
        vo.setName(coupon.getName());
        vo.setCouponType(coupon.getCouponType());
        vo.setCategory(coupon.getCategory());
        vo.setDay(coupon.getDay());
        vo.setDiscount(coupon.getDiscount());
        vo.setIsFixedTime(coupon.getIsFixedTime().intValue() == 1);
        vo.setIsLimited(coupon.getIsLimited().intValue() == 1);
        vo.setLastTotal(coupon.getLastTotal());
        vo.setMinPrice(coupon.getMinPrice());
        vo.setReceiveEndTime(coupon.getReceiveEndTime());
        vo.setReceiveStartTime(coupon.getReceiveStartTime());
        return vo;
    }

    public static final EbMerchantProductGuaranteeGroup acquireMerProdGuaranteeGroup(Map<String, Object> map){
        EbMerchantProductGuaranteeGroup guaranteeGroup = new EbMerchantProductGuaranteeGroup();
        guaranteeGroup.setGroupId(Integer.parseInt(map.get("group_id").toString()));
        guaranteeGroup.setGid(Integer.parseInt(map.get("gid").toString()));
        guaranteeGroup.setIsShow(Integer.parseInt(map.get("is_show").toString()));
        return guaranteeGroup;
    }

    public static final GuaranteeGroupVo transferTo(EbProductGuaranteeGroup group){
        GuaranteeGroupVo vo = new GuaranteeGroupVo();
        vo.setId(group.getId());
        vo.setName(group.getName());
        vo.setCreateTime(group.getCreateTime());
        return vo;
    }

    /**
     * 商户添加商品，获取一个商品对象。
     * @param vo
     * @param merId
     * @return
     * @date 2023-06-21
     */
    public static final EbProduct acquireProduct(ProductAddVo vo, int merId){
        EbProduct product = new EbProduct();
        product.setName(vo.getName());
        product.setUnitName(vo.getUnitName());
        product.setIntro(vo.getIntro());
        product.setKeyword(vo.getKeyword());
        product.setCateId(vo.getCateId());
        product.setBrandId(vo.getBrandId());
        product.setCategoryId(vo.getCategoryId());
        product.setGuaranteeIds(vo.getGuaranteeIds());
        product.setTempId(vo.getTempId());
        product.setSort(vo.getSort());
        product.setSpecType(vo.getSpecType()? 1:0);
        product.setIsSub(vo.getIsSub()? 1:0);
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        product.setIsAudit(0);
        product.setIsShow(0);
        product.setMerId(merId);
        product.setIsDel(0);
        return product;
    }

    public static final void setupProductInfoVo(EbProduct product, ProductInfoVo vo){
        vo.setId(product.getId());
        vo.setCateId(product.getCateId());
        vo.setName(product.getName());
        vo.setBrandId(product.getBrandId());
        vo.setFicti(product.getFicti());
        vo.setFlatPattern(product.getFlatPattern());
//        vo.setGiveIntegral(product.get);
        vo.setCategoryId(product.getCategoryId());
        vo.setImage(product.getImage());
        vo.setKeyword(product.getKeyword());
        vo.setIntro(product.getIntro());
        vo.setSliderImage(product.getSliderImage());
        vo.setSort(product.getSort());
        vo.setGuaranteeIds(product.getGuaranteeIds());
        vo.setSpecType(product.getSpecType() == 1);
        vo.setTempId(product.getTempId());
        vo.setUnitName(product.getUnitName());
    }

    public static final ProductGuaranteeVo transferTo(EbProductGuarantee e){
        ProductGuaranteeVo vo = new ProductGuaranteeVo();
        vo.setId(e.getId());
        vo.setCreateTime(e.getCreateTime());
        vo.setContent(e.getContent());
        vo.setName(e.getName());
        vo.setSort(e.getSort());
        vo.setIcon(e.getIcon());
        vo.setIsShow(e.getIsShow());
        vo.setMerNum(0);
        vo.setProNum(0);
        return vo;
    }
    public static final MerchantConfigInfoVo transferTo(EbMerchant merchant, EbMerchantInfo merchantInfo, String cdnUrl){
        MerchantConfigInfoVo vo = new MerchantConfigInfoVo();
        vo.setAlertStock(merchantInfo.getAlertStock());
        vo.setAddressDetail(merchant.getAddressDetail());
        vo.setAvatar(merchant.getAvatar());
        vo.setBackImage(merchant.getBackImage());
        vo.setIntro(merchant.getIntro());
        vo.setKeywords(merchant.getKeywords());
        vo.setLatitude(merchant.getLatitude());
        vo.setLongitude(merchant.getLongitude());
        if(StringUtils.isNotEmpty(merchant.getCoverImage())){
            vo.setCoverImage(cdnUrl + merchant.getCoverImage());
        }
        if(StringUtils.isNotEmpty(merchant.getPcBackImage())){
            vo.setPcBackImage(cdnUrl + merchant.getPcBackImage());
        }
        if(StringUtils.isNotEmpty(merchant.getPcBanner())){
            vo.setPcBanner(cdnUrl + merchant.getPcBanner());
        }
        if(StringUtils.isNotEmpty(merchant.getRectangleLogo())){
            vo.setRectangleLogo(cdnUrl + merchant.getRectangleLogo());
        }
        if(StringUtils.isNotEmpty(merchant.getStreetBackImage())){
            vo.setStreetBackImage(cdnUrl + merchant.getStreetBackImage());
        }
        vo.setServiceLink(merchantInfo.getServiceLink());
        vo.setServicePhone(merchantInfo.getServicePhone());
        vo.setServiceType(merchantInfo.getServiceType());
        vo.setIsTakeTheir(merchant.getIsTakeTheir());
        return vo;
    }
}
