/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant;

import com.iplatform.base.WechatBaseController;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.ishop.merchant.ArticleCategoryCache;
import com.ishop.merchant.CityCacheProvider;
import com.ishop.merchant.ExpressCache;
import com.ishop.merchant.LevelCache;
import com.ishop.merchant.MerCategoryCacheProvider;
import com.ishop.merchant.MerProductCategoryCache;
import com.ishop.merchant.MerTypeCacheProvider;
import com.ishop.merchant.MerchantCache;
import com.ishop.merchant.ProductAttrCache;
import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.ProductCache;
import com.ishop.merchant.ProductCategoryCache;
import com.ishop.merchant.UserRegCache;
import com.ishop.merchant.UserRegConfigCache;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.service.CouponServiceImpl;
import com.ishop.merchant.service.CouponUserServiceImpl;
import com.ishop.merchant.service.ExpressServiceImpl;
import com.ishop.merchant.service.MerchantApplyServiceImpl;
import com.ishop.merchant.service.MerchantProductCategoryServiceImpl;
import com.ishop.merchant.service.MerchantServiceImpl;
import com.ishop.merchant.service.OrderInvoiceServiceImpl;
import com.ishop.merchant.service.OrderServiceImpl;
import com.ishop.merchant.service.PayServiceImpl;
import com.ishop.merchant.service.ProductAttrValueServiceImpl;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.service.ProductDescriptionServiceImpl;
import com.ishop.merchant.service.ProductGuaranteeServiceImpl;
import com.ishop.merchant.service.ProductRelationServiceImpl;
import com.ishop.merchant.service.ProductRuleServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.merchant.service.ShippingTemplateServiceImpl;
import com.ishop.merchant.service.UserAddressServiceImpl;
import com.ishop.merchant.service.UserBalanceServiceImpl;
import com.ishop.merchant.service.UserBrokerageServiceImpl;
import com.ishop.merchant.service.UserRechargeServiceImpl;
import com.ishop.merchant.service.UserRegConfigServiceImpl;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticle;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantCategory;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbMerchantType;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.OrderDetailFrontVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BaseController
extends WechatBaseController {
    protected void batchUpdateEbUserCache(List<Long> userIds) {
        if (StringUtils.isEmptyList(userIds)) {
            return;
        }
        List<EbUser> userList = this.getUserRegisterService().queryUserList(userIds);
        for (EbUser user : userList) {
            this.getUserRegCache().update(user);
        }
    }

    protected List<OrderInvoiceVo> acquireOrderInvoiceList(String orderNo) {
        EbOrderInvoice param = new EbOrderInvoice();
        param.setOrderNo(orderNo);
        List orderInvoiceList = this.getOrderInvoiceService().select((BasePo)param);
        if (StringUtils.isEmptyList((List)orderInvoiceList)) {
            return new ArrayList<OrderInvoiceVo>(1);
        }
        List<Long> invoiceIdList = orderInvoiceList.stream().map(EbOrderInvoice::getId).collect(Collectors.toList());
        List<EbOrderInvoiceDetail> orderInvoiceDetailList = this.getOrderInvoiceService().queryOrderInvoiceDetailList(invoiceIdList);
        if (StringUtils.isEmptyList(orderInvoiceDetailList)) {
            return new ArrayList<OrderInvoiceVo>(1);
        }
        ArrayList<OrderInvoiceVo> list = new ArrayList<OrderInvoiceVo>(4);
        OrderInvoiceVo vo = null;
        for (EbOrderInvoice e : orderInvoiceList) {
            vo = VoUtils.acquireOrderInvoiceVo(e);
            for (EbOrderInvoiceDetail ed : orderInvoiceDetailList) {
                if (ed.getInvoiceId().longValue() != vo.getId().longValue()) continue;
                vo.addDetailVo(VoUtils.acquireOrderInvoiceDetailVo(ed));
            }
            list.add(vo);
        }
        return list;
    }

    protected PlatformOrderDetailVo acquireCommonOrderDetail(EbOrder order, String orderNo) {
        EbMerchantOrder merchantOrder = this.getOrderService().queryMerchantOrderOne(orderNo);
        List<EbOrderDetail> detailList = this.getOrderService().queryOrderDetailList(orderNo);
        EbUser user = this.getUserRegCache().get(order.getUid());
        EbMerchant merchant = this.getMerchantCache().get(merchantOrder.getMerId());
        PlatformOrderDetailVo vo = VoUtils.acquirePlatformOrderDetailVo(order, merchantOrder);
        vo.setNikeName(user.getNickname());
        vo.setRealName(user.getRealName());
        vo.setMerName(merchant.getName());
        vo.setIsLogoff(Boolean.valueOf(user.getIsLogoff() == 1));
        if (merchantOrder.getClerkId() > 0L) {
            vo.setClerkName(this.getUser(merchantOrder.getClerkId()).getNick_name());
        }
        ArrayList<OrderDetailFrontVo> orderDetailList = new ArrayList<OrderDetailFrontVo>(detailList.size());
        for (EbOrderDetail detail : detailList) {
            orderDetailList.add(VoUtils.acquireOrderDetailFrontVo(detail));
        }
        vo.setOrderDetailList(orderDetailList);
        return vo;
    }

    protected List<PlatformOrderVo> acquireCommonOrderList(List<EbOrder> data) {
        ArrayList<PlatformOrderVo> list = new ArrayList<PlatformOrderVo>(data.size());
        PlatformOrderVo vo = null;
        EbUser user = null;
        EbMerchant merchant = null;
        for (EbOrder order : data) {
            vo = VoUtils.acquirePlatformOrderVo(order);
            user = this.getUserRegCache().get(order.getUid());
            vo.setIsLogoff(Boolean.valueOf(user.getIsLogoff() == 1));
            vo.setNickName(user.getNickname());
            if (order.getMerId() > 0) {
                merchant = this.getMerchantCache().get(order.getMerId());
                vo.setMerName(merchant.getName());
            }
            list.add(vo);
        }
        return list;
    }

    protected ResponseValue acquireArticleDetailVo(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbArticle article = (EbArticle)this.getArticleService().get((BasePo)new EbArticle(id));
        if (article == null) {
            return ResponseValue.success((String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
        }
        return ResponseValue.success((Object)VoUtils.acquireArticleVo(article, this.getCdnUrl(), true));
    }

    protected boolean isPlatformSuper() {
        S_user_core user = this.getCurrentUser();
        int userType = user.getUser_type();
        return userType == 0 || userType == 5;
    }

    protected boolean isMerchant() {
        S_user_core user = this.getCurrentUser();
        int userType = user.getUser_type();
        return userType == 6;
    }

    protected MerchantServiceImpl getMerchantService() {
        return (MerchantServiceImpl)((Object)BeanContextAware.getBeanByType(MerchantServiceImpl.class));
    }

    protected MerchantApplyServiceImpl getMerchantApplyService() {
        return (MerchantApplyServiceImpl)((Object)BeanContextAware.getBeanByType(MerchantApplyServiceImpl.class));
    }

    protected MerCategoryCacheProvider getMerchantCategoryCache() {
        return (MerCategoryCacheProvider)BeanContextAware.getBeanByType(MerCategoryCacheProvider.class);
    }

    protected MerTypeCacheProvider getMerchantTypeCache() {
        return (MerTypeCacheProvider)BeanContextAware.getBeanByType(MerTypeCacheProvider.class);
    }

    protected String getMerchantCategoryName(int categoryId) {
        EbMerchantCategory category = this.getMerchantCategoryCache().get(categoryId);
        if (category == null) {
            this.logger.error("\u7f13\u5b58\u4e2d\u672a\u627e\u5230'\u5546\u6237\u5206\u7c7b'\uff1a{}", (Object)categoryId);
            return "";
        }
        return category.getName();
    }

    protected String getMerchantTypeName(int typeId) {
        EbMerchantType type = this.getMerchantTypeCache().get(typeId);
        if (type == null) {
            this.logger.error("\u7f13\u5b58\u4e2d\u672a\u627e\u5230'\u5546\u6237\u7c7b\u522b'\uff1a{}", (Object)typeId);
            return "";
        }
        return type.getName();
    }

    protected ProductCategoryServiceImpl getProductCategoryService() {
        return (ProductCategoryServiceImpl)((Object)BeanContextAware.getBeanByType(ProductCategoryServiceImpl.class));
    }

    protected ProductCategoryCache getProductCategoryCache() {
        return (ProductCategoryCache)BeanContextAware.getBeanByType(ProductCategoryCache.class);
    }

    protected ProductBrandServiceImpl getProductBrandService() {
        return (ProductBrandServiceImpl)((Object)BeanContextAware.getBeanByType(ProductBrandServiceImpl.class));
    }

    protected ProductBrandCache getProductBrandCache() {
        return (ProductBrandCache)BeanContextAware.getBeanByType(ProductBrandCache.class);
    }

    protected ProductServiceImpl getProductService() {
        return (ProductServiceImpl)((Object)BeanContextAware.getBeanByType(ProductServiceImpl.class));
    }

    protected MerchantCache getMerchantCache() {
        return (MerchantCache)BeanContextAware.getBeanByType(MerchantCache.class);
    }

    protected ProductAttrCache getProductAttrCache() {
        return (ProductAttrCache)BeanContextAware.getBeanByType(ProductAttrCache.class);
    }

    protected ProductAttrValueServiceImpl getProductAttrValueService() {
        return (ProductAttrValueServiceImpl)((Object)BeanContextAware.getBeanByType(ProductAttrValueServiceImpl.class));
    }

    protected ProductDescriptionServiceImpl getProductDescriptionService() {
        return (ProductDescriptionServiceImpl)((Object)BeanContextAware.getBeanByType(ProductDescriptionServiceImpl.class));
    }

    protected MerchantProductCategoryServiceImpl getMerchantProductCategoryService() {
        return (MerchantProductCategoryServiceImpl)((Object)BeanContextAware.getBeanByType(MerchantProductCategoryServiceImpl.class));
    }

    protected MerProductCategoryCache getMerProductCategoryCache() {
        return (MerProductCategoryCache)BeanContextAware.getBeanByType(MerProductCategoryCache.class);
    }

    protected UserRegisterServiceImpl getUserRegisterService() {
        return (UserRegisterServiceImpl)((Object)BeanContextAware.getBeanByType(UserRegisterServiceImpl.class));
    }

    protected UserRegCache getUserRegCache() {
        return (UserRegCache)BeanContextAware.getBeanByType(UserRegCache.class);
    }

    protected String getUserRegisterName(long id) {
        EbUser user = this.getUserRegCache().get(id);
        if (user != null) {
            return user.getNickname();
        }
        return "";
    }

    protected ShippingTemplateServiceImpl getShippingTemplateService() {
        return (ShippingTemplateServiceImpl)((Object)BeanContextAware.getBeanByType(ShippingTemplateServiceImpl.class));
    }

    protected ProductGuaranteeServiceImpl getProductGuaranteeService() {
        return (ProductGuaranteeServiceImpl)((Object)BeanContextAware.getBeanByType(ProductGuaranteeServiceImpl.class));
    }

    protected CouponServiceImpl getCouponService() {
        return (CouponServiceImpl)((Object)BeanContextAware.getBeanByType(CouponServiceImpl.class));
    }

    protected ArticleServiceImpl getArticleService() {
        return (ArticleServiceImpl)((Object)BeanContextAware.getBeanByType(ArticleServiceImpl.class));
    }

    protected CityCacheProvider getCityCache() {
        return (CityCacheProvider)BeanContextAware.getBeanByType(CityCacheProvider.class);
    }

    protected CityServiceImpl getCityService() {
        return (CityServiceImpl)((Object)BeanContextAware.getBeanByType(CityServiceImpl.class));
    }

    protected ProductRelationServiceImpl getProductRelationService() {
        return (ProductRelationServiceImpl)((Object)BeanContextAware.getBeanByType(ProductRelationServiceImpl.class));
    }

    protected CouponUserServiceImpl getCouponUserService() {
        return (CouponUserServiceImpl)((Object)BeanContextAware.getBeanByType(CouponUserServiceImpl.class));
    }

    protected LevelCache getLevelCache() {
        return (LevelCache)BeanContextAware.getBeanByType(LevelCache.class);
    }

    protected OrderServiceImpl getOrderService() {
        return (OrderServiceImpl)((Object)BeanContextAware.getBeanByType(OrderServiceImpl.class));
    }

    protected UserAddressServiceImpl getUserAddressService() {
        return (UserAddressServiceImpl)((Object)BeanContextAware.getBeanByType(UserAddressServiceImpl.class));
    }

    protected PayServiceImpl getPayService() {
        return (PayServiceImpl)((Object)BeanContextAware.getBeanByType(PayServiceImpl.class));
    }

    protected ArticleCategoryCache getArticleCategoryCache() {
        return (ArticleCategoryCache)BeanContextAware.getBeanByType(ArticleCategoryCache.class);
    }

    protected OrderInvoiceServiceImpl getOrderInvoiceService() {
        return (OrderInvoiceServiceImpl)((Object)BeanContextAware.getBeanByType(OrderInvoiceServiceImpl.class));
    }

    protected ProductCache getProductCache() {
        return (ProductCache)BeanContextAware.getBeanByType(ProductCache.class);
    }

    protected ProductRuleServiceImpl getProductRuleService() {
        return (ProductRuleServiceImpl)((Object)BeanContextAware.getBeanByType(ProductRuleServiceImpl.class));
    }

    protected UserRegConfigServiceImpl getUserRegConfigService() {
        return (UserRegConfigServiceImpl)((Object)BeanContextAware.getBeanByType(UserRegConfigServiceImpl.class));
    }

    protected UserRegConfigCache getUserRegConfigCache() {
        return (UserRegConfigCache)BeanContextAware.getBeanByType(UserRegConfigCache.class);
    }

    protected ExpressCache getExpressCache() {
        return (ExpressCache)BeanContextAware.getBeanByType(ExpressCache.class);
    }

    protected ExpressServiceImpl getExpressService() {
        return (ExpressServiceImpl)((Object)BeanContextAware.getBeanByType(ExpressServiceImpl.class));
    }

    protected UserBalanceServiceImpl getUserBalanceService() {
        return (UserBalanceServiceImpl)((Object)BeanContextAware.getBeanByType(UserBalanceServiceImpl.class));
    }

    protected UserRechargeServiceImpl getUserRechargeService() {
        return (UserRechargeServiceImpl)((Object)BeanContextAware.getBeanByType(UserRechargeServiceImpl.class));
    }

    protected UserBrokerageServiceImpl getUserBrokerageService() {
        return (UserBrokerageServiceImpl)((Object)BeanContextAware.getBeanByType(UserBrokerageServiceImpl.class));
    }

    protected EbUser getCurrentEbUser() {
        long userId = this.getCurrentUserId();
        return this.getUserRegCache().get(userId);
    }
}

