/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ArticleCategoryCache;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.vo.ArticleCategoryVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalArticleCateCache
extends AbstractCacheProvider<ArticleCategoryVo>
implements ArticleCategoryCache {
    private ArticleServiceImpl articleService;

    @Override
    public List<ArticleCategoryVo> getList() {
        ArrayList<ArticleCategoryVo> data = new ArrayList<ArticleCategoryVo>(2);
        ArticleCategoryVo vo = null;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            vo = (ArticleCategoryVo)((Cachable)it.next()).getValue();
            if (!vo.getStatus().booleanValue()) continue;
            data.add(vo);
        }
        return data;
    }

    @Override
    public ArticleCategoryVo get(long id) {
        return (ArticleCategoryVo)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(ArticleCategoryVo category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(ArticleCategoryVo category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.articleService.selectAll((BasePo)new EbArticleCategory());
        if (!StringUtils.isEmptyList((List)hosts)) {
            for (EbArticleCategory h : hosts) {
                if (h.getIsDel() == 1) continue;
                cache.put(String.valueOf(h.getId()), (Object)VoUtils.acquireArticleCategoryVo(h, ""));
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.article.cate";
    }

    public Class<?> getProviderType() {
        return ArticleCategoryVo.class;
    }

    public void setArticleService(ArticleServiceImpl articleService) {
        this.articleService = articleService;
    }
}

