/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.model.po.EbProductBrand;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalProductBrandCache
extends AbstractCacheProvider<EbProductBrand>
implements ProductBrandCache {
    private ProductBrandServiceImpl productBrandService;

    @Override
    public EbProductBrand get(int id) {
        return (EbProductBrand)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductBrand category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductBrand category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public List<EbProductBrand> getList() {
        ArrayList<EbProductBrand> allTree = new ArrayList<EbProductBrand>();
        EbProductBrand tempCategory = null;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            tempCategory = (EbProductBrand)((Cachable)it.next()).getValue();
            if (tempCategory.getIsDel() == 1) continue;
            allTree.add(tempCategory);
        }
        return allTree;
    }

    protected int loadDataToCache(Cache cache) {
        List<EbProductBrand> hosts = this.productBrandService.queryAllProductBrandList();
        if (!StringUtils.isEmptyList(hosts)) {
            for (EbProductBrand h : hosts) {
                cache.put(String.valueOf(h.getId()), (Object)h);
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.product.brand";
    }

    public Class<?> getProviderType() {
        return EbProductBrand.class;
    }

    public void setProductBrandService(ProductBrandServiceImpl productBrandService) {
        this.productBrandService = productBrandService;
    }
}

