/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ArticleCategoryCache;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.vo.ArticleCategoryVo;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.List;

public class RedisArticleCateCache
extends RedisCacheProvider<ArticleCategoryVo>
implements ArticleCategoryCache {
    private ArticleServiceImpl articleService;

    public RedisArticleCateCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.articleService.selectAll((BasePo)new EbArticleCategory());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) < (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2dCategory\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (EbArticleCategory h : hosts) {
                    if (h.getIsDel() == 1) continue;
                    cache.put(String.valueOf(h.getId()), (Object)VoUtils.acquireArticleCategoryVo(h, ""));
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public List<ArticleCategoryVo> getList() {
        ArrayList<ArticleCategoryVo> data = new ArrayList<ArticleCategoryVo>(2);
        ArticleCategoryVo vo = null;
        for (String value : ((RedisCache)this.getCache()).getIterator(null)) {
            try {
                vo = (ArticleCategoryVo)JsonUtils.jsonStringToObject((String)value, ArticleCategoryVo.class);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException("redis\u5b58\u50a8'S_category'\u89e3\u6790\u9519\u8bef\uff1a" + value, (Throwable)ex);
            }
            if (!vo.getStatus().booleanValue()) continue;
            data.add(vo);
        }
        return data;
    }

    @Override
    public ArticleCategoryVo get(long id) {
        return (ArticleCategoryVo)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(ArticleCategoryVo category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(ArticleCategoryVo category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.article.cate";
    }

    public Class<?> getProviderType() {
        return ArticleCategoryVo.class;
    }

    public void setArticleService(ArticleServiceImpl articleService) {
        this.articleService = articleService;
    }
}

