/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.MerCategoryCacheProvider;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.model.po.EbMerchantCategory;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RedisMerCategoryCache
extends RedisCacheProvider<EbMerchantCategory>
implements MerCategoryCacheProvider {
    private MerchantCategoryServiceImpl merchantCategoryService;

    public RedisMerCategoryCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public List<EbMerchantCategory> getList() {
        ArrayList<EbMerchantCategory> list = new ArrayList<EbMerchantCategory>(8);
        EbMerchantCategory category = null;
        String temp = null;
        try {
            Iterator iterator = ((RedisCache)this.getCache()).getIterator(null).iterator();
            while (iterator.hasNext()) {
                String value;
                temp = value = (String)iterator.next();
                category = (EbMerchantCategory)JsonUtils.jsonStringToObject((String)value, EbMerchantCategory.class);
                list.add(category);
            }
            return list;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException("redis\u5b58\u50a8'EbMerchantCategory'\u89e3\u6790\u9519\u8bef\uff1a" + temp, (Throwable)ex);
        }
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.merchantCategoryService.selectAll((BasePo)new EbMerchantCategory());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (EbMerchantCategory h : hosts) {
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public EbMerchantCategory get(int id) {
        return (EbMerchantCategory)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchantCategory category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbMerchantCategory category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.merchant.category";
    }

    public Class<?> getProviderType() {
        return EbMerchantCategory.class;
    }

    public void setMerchantCategoryService(MerchantCategoryServiceImpl merchantCategoryService) {
        this.merchantCategoryService = merchantCategoryService;
    }
}

