/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.MerProductCategoryCache;
import com.ishop.merchant.service.MerchantProductCategoryServiceImpl;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.merchant.util.cache.MerProductCateSortComparator;
import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisListCacheProvider;
import java.util.Iterator;
import java.util.List;

public class RedisMerProductCategoryCache
extends RedisListCacheProvider<EbMerchantProductCategory>
implements MerProductCategoryCache {
    private final MerProductCateSortComparator sortComparator = new MerProductCateSortComparator();
    private MerchantProductCategoryServiceImpl merchantProductCategoryService;

    public RedisMerProductCategoryCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putList(String key, List<EbMerchantProductCategory> data) {
        this.putCacheList(key, data);
    }

    @Override
    public void putList(String key, List<EbMerchantProductCategory> data, long expiredSeconds) {
        this.putCacheList(key, data, expiredSeconds);
    }

    @Override
    public void putListAppend(String key, EbMerchantProductCategory data) {
        this.putCacheListAppend(key, data);
    }

    @Override
    public List<ProductCategoryVo> getTree(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("\u5546\u6237\u5546\u54c1\u5206\u7c7b\u5fc5\u987b\u63d0\u4f9b");
        }
        List<EbMerchantProductCategory> list = this.getList(key);
        if (!StringUtils.isEmptyList(list)) {
            EbMerchantProductCategory e = null;
            Iterator<EbMerchantProductCategory> it = list.iterator();
            while (it.hasNext()) {
                e = it.next();
                if (e.getIsDel() == 1) {
                    it.remove();
                }
                if (e.getIsShow() != 0) continue;
                it.remove();
            }
        }
        return ProductCategoryUtils.acquireListTree(list, this.sortComparator);
    }

    @Override
    public List<EbMerchantProductCategory> getList(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key\u5fc5\u987b\u63d0\u4f9b");
        }
        List<EbMerchantProductCategory> list = this.getCacheList(key);
        if (list == null) {
            logger.debug("\u6ca1\u6709\u7f13\u5b58\u5546\u6237\u5546\u54c1\u5206\u7c7b\uff0c\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\u5e76\u7f13\u5b58\uff1a" + key);
            list = this.merchantProductCategoryService.queryMerchantProductCategoryList(Integer.parseInt(key));
            if (list == null) {
                logger.warn("\u6570\u636e\u5e93\u672a\u52a0\u8f7d\u5230:\u5546\u6237\u5546\u54c1\u5206\u7c7b\uff0c\u65e0\u6cd5\u7f13\u5b58\uff1a" + key);
                return null;
            }
            this.putList(key, list);
        }
        return list;
    }

    @Override
    public void removeList(String key, EbMerchantProductCategory data) {
        this.removeCacheList(key, data);
    }

    public String getProviderName() {
        return "cache.mer.product.cate";
    }

    public Class<?> getProviderType() {
        return EbMerchantProductCategory.class;
    }

    public void setMerchantProductCategoryService(MerchantProductCategoryServiceImpl merchantProductCategoryService) {
        this.merchantProductCategoryService = merchantProductCategoryService;
    }
}

