/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ProductAttrCache;
import com.ishop.merchant.service.ProductAttrServiceImpl;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.model.po.EbProductAttr;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisListCacheProvider;
import java.util.List;

public class RedisProductAttrCache
extends RedisListCacheProvider<EbProductAttr>
implements ProductAttrCache {
    private ProductAttrServiceImpl productAttrService;

    public RedisProductAttrCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putList(String key, List<EbProductAttr> data) {
        this.putCacheList(key, data);
    }

    @Override
    public void putList(String key, List<EbProductAttr> data, long expiredSeconds) {
        this.putCacheList(key, data, expiredSeconds);
    }

    @Override
    public void putListAppend(String key, EbProductAttr data) {
        this.putCacheListAppend(key, data);
    }

    @Override
    public List<EbProductAttr> getList(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key\u5fc5\u987b\u63d0\u4f9b");
        }
        List<EbProductAttr> list = this.getCacheList(key);
        if (list == null) {
            logger.debug("\u6ca1\u6709\u7f13\u5b58\u5546\u54c1\u5c5e\u6027\uff0c\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\u5e76\u7f13\u5b58\uff1a" + key);
            String[] typeAndProductId = ProductAttrUtils.splitTypeAndProductId(key);
            list = this.productAttrService.queryProductAttrList(Integer.parseInt(typeAndProductId[0]), Long.parseLong(typeAndProductId[1]));
            if (list == null) {
                logger.warn("\u6570\u636e\u5e93\u672a\u52a0\u8f7d\u5230\u5546\u54c1\u5c5e\u6027\uff0c\u65e0\u6cd5\u7f13\u5b58\uff1a" + key);
                return null;
            }
            this.putList(key, list);
        }
        return list;
    }

    @Override
    public void removeList(String key, EbProductAttr data) {
        this.removeCacheList(key, data);
    }

    @Override
    public void removeList(String key) {
        this.removeCacheList(key);
    }

    public String getProviderName() {
        return "cache.product.attr";
    }

    public Class<?> getProviderType() {
        return EbProductAttr.class;
    }

    public void setProductAttrService(ProductAttrServiceImpl productAttrService) {
        this.productAttrService = productAttrService;
    }
}

