/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.model.po.EbProductBrand;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.List;

public class RedisProductBrandCache
extends RedisCacheProvider<EbProductBrand>
implements ProductBrandCache {
    private ProductBrandServiceImpl productBrandService;

    public RedisProductBrandCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    protected int loadDataToCache(Cache cache) {
        List<EbProductBrand> hosts = this.productBrandService.queryAllProductBrandList();
        if (!StringUtils.isEmptyList(hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (EbProductBrand h : hosts) {
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public List<EbProductBrand> getList() {
        ArrayList<EbProductBrand> allTree = new ArrayList<EbProductBrand>();
        EbProductBrand tempCategory = null;
        for (String value : this.getCache().getIterator(null)) {
            try {
                tempCategory = (EbProductBrand)JsonUtils.jsonStringToObject((String)value, EbProductBrand.class);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException("redis\u5b58\u50a8'EbProductBrand'\u89e3\u6790\u9519\u8bef\uff1a" + value, (Throwable)ex);
            }
            if (tempCategory.getIsDel() == 1) continue;
            allTree.add(tempCategory);
        }
        return allTree;
    }

    @Override
    public EbProductBrand get(int id) {
        return (EbProductBrand)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductBrand category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductBrand category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.product.brand";
    }

    public Class<?> getProviderType() {
        return EbProductBrand.class;
    }

    public void setProductBrandService(ProductBrandServiceImpl productBrandService) {
        this.productBrandService = productBrandService;
    }
}

